/*
 *
 * g_kde_dlg.cpp - part of FTE which is Copyright (c) 1994-1996, Marko Macek

 * KDE Gui implementation for the FTE Editor
 * derived from the original Qt GUI module written by Marko Macek
 *
 * this file was initially written by Roberto Alsina
 *
 * GUI modifications (to be more KDE conform) by Alexander Sanda - as@psa.at
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <assert.h>
#include <stdarg.h>

#include "sysdep.h"
#include "feature.h"
#include "console.h"
#include "gui.h"
#include "s_files.h"
#include "c_history.h"

#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qbutton.h>
#include <qpushbt.h>
#include <qfiledlg.h>
#include <qlined.h>
#include <qlayout.h>
#include <qcombo.h>
#include <qchkbox.h>
#include <qgrpbox.h>
#include <kfiledialog.h>

#define DEBUGX(x) // printf x

unsigned long HaveGUIDialogs = GUIDLG_FILE | GUIDLG_CHOICE | GUIDLG_PROMPT | GUIDLG_FIND | GUIDLG_FINDREPLACE;

class PromptDlg : public QDialog
{

    Q_OBJECT

public:
    
    PromptDlg ();
    
    virtual ~PromptDlg() {};
    
    QGroupBox* label;
    QComboBox* entry;
    
    
};

class FindDlg : public QDialog
{
    Q_OBJECT
public:
    FindDlg (long options=0);
    virtual ~FindDlg() {};

    QComboBox* entry;
    QCheckBox *a;
    QCheckBox *b;
    QCheckBox *c;
    QCheckBox *d;
    QCheckBox *e;
    QCheckBox *g;
    QCheckBox *i;
    QCheckBox *j;
    QCheckBox *r;
    QCheckBox *x;
    
};

class FindReplaceDlg : public QDialog
{
    Q_OBJECT
public:
    FindReplaceDlg (long options=0);
    virtual ~FindReplaceDlg() {};

    QComboBox* entry;
    QComboBox* entry2;
    QCheckBox *a;
    QCheckBox *b;
    QCheckBox *c;
    QCheckBox *d;
    QCheckBox *e;
    QCheckBox *g;
    QCheckBox *i;
    QCheckBox *j;
    QCheckBox *r;
    QCheckBox *x;
    
};

PromptDlg::PromptDlg
    () : QDialog(0,0, TRUE )
{
    
    label=new QGroupBox (this, "_box");
    label->setGeometry(5, 5, 290, 65);
    entry=new QComboBox (true, label);
    entry->setGeometry(5, 20, label->width() - 10, label->height() - 40);
    
    QPushButton *b1=new QPushButton(this);
    QPushButton *b2=new QPushButton(this);

    b1->setText("Ok");
    b1->setDefault( true );
    b2->setText("Cancel");

    QObject::connect (b1,SIGNAL(clicked()),SLOT(accept()));
    QObject::connect (b2,SIGNAL(clicked()),SLOT(reject()));
    entry->setFocus();

    b1->setMinimumSize(b1->sizeHint());
    b2->setMinimumSize(b2->sizeHint());

    if (b1->minimumSize().width() <80)
        b1->setFixedWidth(80);
    if (b2->minimumSize().width() <80)
        b2->setFixedWidth(80);

    b1->setFixedHeight(25);
    b2->setFixedHeight(25);
    
    resize(300,110);
    b1->move(10, height() - 30);
    b2->move(width() - 90, height() - 30);
}

FindDlg::FindDlg
    (long options) : QDialog(0,0, TRUE )
{
    QGroupBox *label=new QGroupBox ("Find what:", this, "_grp");
    QGroupBox *soptions = new QGroupBox("Options:", this, "_opt");
    QFrame *soframe = new QFrame(soptions, "_frame");
    
    entry=new QComboBox (true, label);
    QPushButton *b1=new QPushButton(this);
    QPushButton *b2=new QPushButton(this);
    b1->setText("Find");
    b1->setDefault( true );
    b2->setText("Cancel");
    QObject::connect (b1,SIGNAL(clicked()),SLOT(accept()));
    QObject::connect (b2,SIGNAL(clicked()),SLOT(reject()));
    entry->setFocus();
    
    a=new QCheckBox("All Occurences", soframe);
    a->setChecked(options & SEARCH_ALL);
    b=new QCheckBox("In Block", soframe);
    b->setChecked(options & SEARCH_BLOCK);
    c=new QCheckBox("Center finds", soframe);
    c->setChecked(options & SEARCH_CENTER);
    d=new QCheckBox("Delete Line", soframe);
    d->setChecked(options & SEARCH_DELETE);
    e=new QCheckBox("e option??", soframe);
    e->setChecked(false);
    g=new QCheckBox("Global Search", soframe);
    g->setChecked(options & SEARCH_GLOBAL);
    i=new QCheckBox("Ignore Case", soframe);
    i->setChecked(options & SEARCH_NCASE);
    j=new QCheckBox("Join Line", soframe);
    j->setChecked(options & SEARCH_JOIN);
    r=new QCheckBox("Reverse search", soframe);
    r->setChecked(options & SEARCH_BACK);
    x=new QCheckBox("Use RegExp", soframe);
    x->setChecked(options & SEARCH_RE);


    a->setMinimumSize(a->sizeHint());
    b->setMinimumSize(b->sizeHint());
    c->setMinimumSize(c->sizeHint());
    d->setMinimumSize(d->sizeHint());
    e->setMinimumSize(e->sizeHint());
    g->setMinimumSize(g->sizeHint());
    i->setMinimumSize(i->sizeHint());
    j->setMinimumSize(j->sizeHint());
    r->setMinimumSize(r->sizeHint());
    x->setMinimumSize(x->sizeHint());

    soptions->setGeometry(10, 70, 330, 140);
    soframe->setGeometry(3, 15, soptions->width() - 6, soptions->height() - 20);
    QGridLayout *v = new QGridLayout(soframe, 5, 2, 5);
    v->addWidget(a, 0, 0);
    v->addWidget(b, 1, 0);
    v->addWidget(c, 2, 0);
    v->addWidget(d, 3, 0);
    v->addWidget(e, 4, 0);
    v->addWidget(g, 0, 1);
    v->addWidget(i, 1, 1);
    v->addWidget(j, 2, 1);
    v->addWidget(r, 3, 1);
    v->addWidget(x, 4, 1);
    v->addColSpacing(0, 10);
    v->addColSpacing(1, 10);
    // button geometry
    
    b1->setMinimumSize(b1->sizeHint());
    b2->setMinimumSize(b2->sizeHint());
    if (b1->minimumSize().width() <80)
        b1->setFixedWidth(80);
    if (b2->minimumSize().width() <80)
        b2->setFixedWidth(80);

    b1->setFixedHeight(25);
    b2->setFixedHeight(25);
        
    label->setGeometry(10, 5, 330, 55);
    entry->setGeometry(10, 15, label->width() - 20, label->height() - 30);
    resize(350, 250);
    setMinimumSize(350, 250);
    setMaximumSize(350, 250);
    v->activate();
    b1->move(10, height() - 30);
    b2->move(width() - 90, height() - 30);
    setCaption("Search for text");
}

FindReplaceDlg::FindReplaceDlg
    (long options) : QDialog(0,0, TRUE )
{
    
    QGroupBox *label = new QGroupBox ("Find what",this, "_g1");
    QLabel *label2 = new QLabel ("Replace with",this);

    entry=new QComboBox (true, label);
    entry2=new QComboBox (true, label);

    QPushButton *b1=new QPushButton(this);
    QPushButton *b2=new QPushButton(this);
    b1->setText("Ok");
    b1->setDefault( true );
    b2->setText("Cancel");

    QObject::connect (b1,SIGNAL(clicked()),SLOT(accept()));
    QObject::connect (b2,SIGNAL(clicked()),SLOT(reject()));
    entry->setFocus();
    
    QGroupBox *soptions = new QGroupBox("Options", this, "_g2");
    QFrame *soframe = new QFrame(soptions, "_box1");
    
    QGridLayout *gr=new QGridLayout(soframe, 5,2,5);

    a=new QCheckBox("All Occurences", soframe);
    a->setChecked(options & SEARCH_ALL);
    b=new QCheckBox("In Block", soframe);
    b->setChecked(options & SEARCH_BLOCK);
    c=new QCheckBox("Center finds", soframe);
    c->setChecked(options & SEARCH_CENTER);
    d=new QCheckBox("Delete Line", soframe);
    d->setChecked(options & SEARCH_DELETE);
    e=new QCheckBox("e option??", soframe);
    e->setChecked(false);
    g=new QCheckBox("Global Search", soframe);
    g->setChecked(options & SEARCH_GLOBAL);
    i=new QCheckBox("Ignore Case", soframe);
    i->setChecked(options & SEARCH_NCASE);
    j=new QCheckBox("Join Line", soframe);
    j->setChecked(options & SEARCH_JOIN);
    r=new QCheckBox("Reverse search", soframe);
    r->setChecked(options & SEARCH_BACK);
    x=new QCheckBox("Use RegExp", soframe);
    x->setChecked(options & SEARCH_RE);

    a->setMinimumSize(a->sizeHint());
    b->setMinimumSize(b->sizeHint());
    c->setMinimumSize(c->sizeHint());
    d->setMinimumSize(d->sizeHint());
    e->setMinimumSize(e->sizeHint());
    g->setMinimumSize(g->sizeHint());
    i->setMinimumSize(i->sizeHint());
    j->setMinimumSize(j->sizeHint());
    r->setMinimumSize(r->sizeHint());
    x->setMinimumSize(x->sizeHint());

    
    if (b1->minimumSize().width() <75)
        b1->setFixedWidth(75);
    if (b2->minimumSize().width() <75)
        b2->setFixedWidth(75);



    gr->addWidget(a,0,0);
    gr->addWidget(b,0,1);
    gr->addWidget(c,1,0);
    gr->addWidget(d,1,1);
    gr->addWidget(e,2,0);
    gr->addWidget(g,2,1);
    gr->addWidget(i,3,0);
    gr->addWidget(j,3,1);
    gr->addWidget(r,4,0);
    gr->addWidget(x,4,1);
    
    resize(350,300);

    label->setGeometry(10, 5, width() - 20, 110);
    entry->setGeometry(5, 15, label->width() - 10, 25);
    entry2->setGeometry(5, 70, label->width() - 10, 25);
    label2->adjustSize();
    label2->move(20, 60);

    soptions->setGeometry(10, 120, width() - 20, 140);
    soframe->setGeometry(5, 15, soptions->width() - 10, soptions->height() - 20);
    
    // button geometry
    
    b1->setMinimumSize(b1->sizeHint());
    b2->setMinimumSize(b2->sizeHint());
    if (b1->minimumSize().width() <80)
        b1->setFixedWidth(80);
    if (b2->minimumSize().width() <80)
        b2->setFixedWidth(80);

    b1->setFixedHeight(25);
    b2->setFixedHeight(25);

    b1->move(10, height() - 30);
    b2->move(width() - 90, height() - 30);
    setCaption("Search and replace");
}

int DLGGetFile(GView *v, char *Prompt, unsigned int BufLen, char *FileName, int Flags) {
    static KFileDialog *kfd = 0;
    
    QString fn;
    char filter[MAXPATH] = "*";
    char directory[MAXPATH];
    const char *dc = directory;
    
    assert(BufLen > 0);

    v = v;
    
    JustDirectory(FileName, directory);

    DEBUGX(("Doing file dialog\n"));

    if(!kfd) {
        kfd = new KFileDialog(directory, filter, 0, 0, true, false);
    }
    else {
        // kfd->setDir((const char *)dc);
        kfd->setFilter(filter);
    }
    
    kfd->setCaption(Prompt);

    if( !kfd->exec() )
        return 0;

    fn = kfd->selectedFile();
    DEBUGX(("File dialog done\n"));
    if (fn.isNull())
        return 0;
    strncpy(FileName, fn, BufLen);
    FileName[BufLen - 1] = 0;
    DEBUGX(("selected %s\n", FileName));
    return FileName[0] ? 1 : 0;
}

const int kMaxButton = 16;

class QChoiceBox : public QDialog {
    Q_OBJECT
public:
    QChoiceBox(QWidget *parent=0, const char *name=0);

    void setText(const char *text);
    void addButton(const char *text);

    void adjustSize();

    int getChoice() { return buttonActivated; }

public slots:
    void pressed();
    void released();
    void clicked();

protected:
    void resizeEvent(QResizeEvent *);

private:
    QLabel *label;
    QPushButton *button[kMaxButton];
    QFrame *box;
    int buttonCount;
    int buttonArmed;
    int buttonSelected;
    int buttonActivated;
    void *reserved1;
    void *reserved2;
};


QChoiceBox::QChoiceBox(QWidget *parent, const char *name)
    : QDialog(parent, name, TRUE)
{
    initMetaObject();

    buttonSelected = -1;
    buttonCount = 0;
    buttonActivated = -1;
    buttonArmed = -1;
    
    box = new QFrame(this, "_box");
    box->setFrameStyle(QFrame::Box | QFrame::Sunken);
    label = new QLabel(this, "text");
    CHECK_PTR(label);
    label->setAlignment(AlignCenter);
}

void QChoiceBox::setText(const char *text) {
    QString t(text);
    if(!strcmp(caption(), "About")) {
        t.append("\\n\\n");
        t.append("KDE additions");
    }
    label->setText(t);
}

void QChoiceBox::addButton(const char *text) {
    assert(buttonCount < kMaxButton);

    button[buttonCount] = new QPushButton(this);
    CHECK_PTR(button[buttonCount]);
    connect(button[buttonCount], SIGNAL(clicked()), SLOT(clicked()));
    connect(button[buttonCount], SIGNAL(pressed()), SLOT(pressed()));
    connect(button[buttonCount], SIGNAL(released()), SLOT(released()));
    button[buttonCount]->setText(text ? text : "?" );
    button[buttonCount]->resize(100, 25);
    buttonCount++;
}

void QChoiceBox::adjustSize() {
    int w_buttons = buttonCount * 100 + (buttonCount - 1) * 10;

    label->adjustSize();

    int w = QMAX(w_buttons, label->width());
    int h = button[0]->height() + label->height();
    h += 40;  // margins
    w += 20;  // margins
    resize( w, h);
    for(int i = 0; i < buttonCount; i++)
        button[i]->move((width() - w_buttons) / 2 + (i * 100) + (i * 10), height() - 30);
    setMinimumSize(w, h);
    setMaximumSize(w, h);
    label->move((w - label->width()) / 2, 10);
    box->setGeometry(5, 5, w - 10, label->height() + 20);
}

void QChoiceBox::resizeEvent( QResizeEvent * ) {

    adjustSize();
    /*
    int i;
    
    for (i = 0; i < buttonCount; i++) {
        button[i]->adjustSize();
    }
    label->adjustSize();
    int h = (height() - button[0]->height() - label->height())/3;
    int x = 10;

    for (i = 0; i < buttonCount; i++) {
        button[i]->move(x, height() - h - button[i]->height());
        x += button[i]->width() + 10;
    }
    label->move( 10, h );
    */
}

void QChoiceBox::pressed() {
    int i;

    buttonSelected = -1;
    for (i = 0; i < buttonCount; i++)
        if (button[i]->isDown())
            buttonSelected = i;
    buttonArmed = buttonSelected;
    DEBUGX(("selected: %d\n", buttonSelected));
}

void QChoiceBox::released() {
    buttonSelected = -1;
    DEBUGX(("released\n"));
}

void QChoiceBox::clicked() {
    buttonActivated = buttonArmed;
    DEBUGX(("activated: %d\n", buttonActivated));
    accept();
}

#include "g_kde_dlg.moc"

int DLGPickChoice(GView *v, char *ATitle, int NSel, va_list ap, int Flags) {
    QChoiceBox *cb = new QChoiceBox();
    CHECK_PTR(cb);
    cb->setCaption( ATitle );

    for (int i = 0; i < NSel; i++)
        cb->addButton(va_arg(ap, char *));

    char msg[1024];
    char *fmt;
    fmt = va_arg(ap, char *);
    vsprintf(msg, fmt, ap);
    
    cb->setText(msg);
    
    int retcode = cb->exec();
    
    delete cb;
    if (retcode == QDialog::Accepted)
        return cb->getChoice();
    return -1;
}

void InsertHistory(QComboBox *combo, int id, int maxlen) {
    int i, count;
    char *str;
    count = CountInputHistory(id);
    
    str = (char *)malloc(maxlen + 1);
    if (str == 0)
        return;
    
    for (i = 0; i < count; i++) {
        if (GetInputHistory(id, str, maxlen, i + 1) == 1)
            combo->insertItem(str);
    }
    free(str);
}

static SearchReplaceOptions SearchOpt;


int DLGGetFind(GView *View, SearchReplaceOptions &sr) {
    
    FindDlg *dlg=new FindDlg(sr.Options);
    InsertHistory (dlg->entry,HIST_SEARCH,50);
    int retcode= dlg->exec();

    sr.ok=0;
    
    if (retcode==QDialog::Accepted)
    {
        sr.ok=1;
        strncpy(sr.strSearch, dlg->entry->currentText(), MAXSEARCH);
        sr.strSearch[MAXSEARCH - 1] = 0;
        AddInputHistory (HIST_SEARCH,sr.strSearch);

        sr.Options=0;
        sr.Options+=dlg->a->isChecked()*SEARCH_ALL;
        sr.Options+=dlg->b->isChecked()*SEARCH_BLOCK;
        sr.Options+=dlg->c->isChecked()*SEARCH_CENTER;
        sr.Options+=dlg->d->isChecked()*SEARCH_DELETE;
        sr.Options+=dlg->e->isChecked()*0;
        sr.Options+=dlg->g->isChecked()*SEARCH_GLOBAL;
        sr.Options+=dlg->i->isChecked()*SEARCH_NCASE;
        sr.Options+=dlg->j->isChecked()*SEARCH_JOIN;
        sr.Options+=dlg->r->isChecked()*SEARCH_BACK;
        sr.Options+=dlg->x->isChecked()*SEARCH_RE;

        return 1;
//        return sr.strSearch[0] ? 1 : 0;
    }
    else return 0;
}



int DLGGetFindReplace(GView *View, SearchReplaceOptions &sr) {

    SearchOpt = sr;

    FindReplaceDlg *dlg=new FindReplaceDlg(sr.Options);
    InsertHistory (dlg->entry,HIST_SEARCH,50);
    InsertHistory (dlg->entry2,HIST_SEARCH,50);
    int retcode= dlg->exec();

    sr.ok=0;
    
    if (retcode==QDialog::Accepted)
    {
        sr.ok=1;
        strncpy(sr.strSearch, dlg->entry->currentText(), MAXSEARCH);
        sr.strSearch[MAXSEARCH - 1] = 0;
        AddInputHistory (HIST_SEARCH,sr.strSearch);

        strncpy(sr.strReplace, dlg->entry2->currentText(), MAXSEARCH);
        sr.strReplace[MAXSEARCH - 1] = 0;
        AddInputHistory (HIST_SEARCH,sr.strReplace);

        sr.Options=0;
        sr.Options+=dlg->a->isChecked()*SEARCH_ALL;
        sr.Options+=dlg->b->isChecked()*SEARCH_BLOCK;
        sr.Options+=dlg->c->isChecked()*SEARCH_CENTER;
        sr.Options+=dlg->d->isChecked()*SEARCH_DELETE;
        sr.Options+=dlg->e->isChecked()*0;
        sr.Options+=dlg->g->isChecked()*SEARCH_GLOBAL;
        sr.Options+=dlg->i->isChecked()*SEARCH_NCASE;
        sr.Options+=dlg->j->isChecked()*SEARCH_JOIN;
        sr.Options+=dlg->r->isChecked()*SEARCH_BACK;
        sr.Options+=dlg->x->isChecked()*SEARCH_RE;
        sr.Options|=SEARCH_REPLACE;

        return 1;
    }
    sr=SearchOpt;
    return 0;
}



int DLGGetStr(GView *View, char *Prompt, unsigned int BufLen, char *Str, int HistId, int Flags) {

    QString caption;
    
    assert(BufLen > 0);
    
    caption = "KFte ";
    caption.append(Prompt);
    
    PromptDlg *dlg=new PromptDlg();
    dlg->label->setTitle(Prompt);
    dlg->setCaption(caption);
    InsertHistory (dlg->entry,HistId,50);
    dlg->entry->insertItem(Str);
    int retcode= dlg->exec();
    
    if (retcode==QDialog::Accepted)
    {
        strncpy(Str, dlg->entry->currentText(), BufLen);
        Str[BufLen - 1] = 0;
        AddInputHistory (HistId,Str);
        return Str[0] ? 1 : 0;
    }
    else return 0;
}

