/**********************************************************************

	--- Qt Architect generated file ---

	File: PrintDialog.cpp
	Last generated: Fri Mar 13 14:39:12 1998

 *********************************************************************/

#include "PrintDialog.h"
#include "debug.h"
#include <qbitmap.h>

// the bitmaps
#include "arrow_left.xbm"
#include "arrow_right.xbm"
#include "arrow_up.xbm"
#include "arrow_down.xbm"

#define Inherited PrintDialogData

// An aggregat that makes the code simpler,
// (it may be possible to simplify this as most
// of the information is used multiple times around 
// the whole sourcecode. The aggregat contains ALWAYS
// an even number of strings, and NoOfStrings is the 
// number of pointers in the aggregat, not the number 
// of keys or descriptions.
const char* PrintDialog::Fields[]= {
  "name", "name", 
  "first name", "firstname", 
  "email address", "email",
  "second email address", "email2",
  "third email address", "email3",
  "telephone number", "telephone",
  "town", "town", 
  "address", "address",
  "additional name", "additionalName",
  "name prefix", "namePrefix",
  "formatted name", "fn",
  "comment", "comment",
  "organization", "org",
  "org unit", "orgUnit",
  "org subunit", "orgSubUnit",
  "title", "title",
  "role", "role",
  "fax number", "fax",
  "modem number", "modem",
  "homepage URL", "URL",
  "birthday", "birthday" };
const int PrintDialog::NoOfFields=sizeof(Fields)/sizeof(Fields[0]);

PrintDialog::PrintDialog
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
  int count;
  // create the bitmaps:
  QBitmap previous
    (16, 16, (unsigned char*)arrow_left_bits, true);
  QBitmap next
    (16, 16, (unsigned char*)arrow_right_bits, true);  
  QBitmap up
    (16, 16, (unsigned char*)uparrow_bits, true);
  QBitmap down
    (16, 16, (unsigned char*)arrow_down_bits, true);
  // -----
  setCaption(i18n("Configure printing"));
  buttonOK->setText(i18n("OK"));
  buttonCancel->setText(i18n("Cancel"));
  labelPossible->setText(i18n("Possible fields"));
  labelSelected->setText(i18n("Selected fields"));
  buttonSelect->setPixmap(next);
  buttonUnselect->setPixmap(previous);
  buttonUp->setPixmap(up);
  buttonDown->setPixmap(down);
  // ----- insert the possible fields:
  for(count=0; count<NoOfFields; count++)
    {
      // WORK_TO_DO: add strings in Fields to translation!
      lbPossible->insertItem(i18n(Fields[count]));
      possibleKeys.push_back(Fields[count+1]);
      // skip key field:
      count++;
    }
  CHECK(possibleKeys.size()==lbPossible->count());
  // -----
  connect(lbPossible, SIGNAL(selected(int)),
	  SLOT(select(int)));
  connect(lbSelected, SIGNAL(selected(int)),
	  SLOT(unSelect(int)));
  connect(buttonSelect, SIGNAL(clicked()),
	  SLOT(select()));
  connect(buttonUnselect, SIGNAL(clicked()),
	  SLOT(unSelect()));
  // ----- now select last set of keys:
  // ni since ConfigDB completely supports string lists
  {
    const char* Keys[]={
      "title", "firstname", "name", "telephone", 
      "address", "town" };
    const int Size=sizeof(Keys)/sizeof(Keys[0]);
    int count;
    for(count=0; count<Size; count++)
      {
	select(Keys[count]);
      }
  }
  // -----
}

void PrintDialog::select(const string& key)
{
  ID(bool GUARD=true);
  REQUIRE(!key.empty());
  // ########################################################
  // This method selects a field through its key.
  // It utilizes the Fields-aggregate.
  int index;
  list<string>::iterator pos=possibleKeys.begin();
  for(index=0; (unsigned)index<possibleKeys.size(); index++)
    {
      if(key==*pos)
	{
	  break;
	}
      ++pos;
    }
  // only valid keys are allowed:
  CHECK(pos!=possibleKeys.end()); 
  // now index indicates the key to select
  LG(GUARD, "PrintDialog::select: found key %s at index %i, "
     "description is %s.\n", key.c_str(), index, 
     lbPossible->text(index));
  select(index);
  // ########################################################
}

void PrintDialog::select(int index)
{
  ID(bool GUARD=true);
  REQUIRE(index>=0);
  CHECK((unsigned)index<lbPossible->count());
  // ########################################################
  // This method selects a field through its position 
  // in the "possible fields" listbox. It is connected 
  // to QListBox::selected(int).
  string text;
  string key;
  list<string>::iterator pos;
  text=lbPossible->text(index);
  lbPossible->removeItem(index);
  lbSelected->insertItem(text.c_str());
  LG(GUARD, "PrintDialog::select: "
     "moved item %s (%i) to \"selected\" box.\n", 
     text.c_str(), index);
  pos=possibleKeys.begin();
  advance(pos, index);
  key=(*pos);
  possibleKeys.erase(pos);
  selectedKeys.push_back(key);
  LG(GUARD, "PrintDialog::select: "
     "moved key %s (%i) to selected keys list.\n", 
     key.c_str(), index);  
  // ########################################################
}

void PrintDialog::unSelect(int index)
{
  ID(bool GUARD=true);
  REQUIRE(index>=0);
  CHECK((unsigned)index<lbSelected->count());
  // ########################################################
  // This method deselects a field through its position 
  // in the "selected fields" listbox.
  string text;
  string key;
  list<string>::iterator pos;
  text=lbSelected->text(index);
  lbSelected->removeItem(index);
  lbPossible->insertItem(text.c_str());
  LG(GUARD, "PrintDialog::unSelect: "
     "moved item %s (%i) to \"possible\" box.\n", 
     text.c_str(), index);
  pos=selectedKeys.begin();
  advance(pos, index);
  key=(*pos);
  selectedKeys.erase(pos);
  possibleKeys.push_back(key);
  LG(GUARD, "PrintDialog::unSelect: "
     "moved key %s (%i) to possible keys list.\n", 
     key.c_str(), index);  
  // ########################################################
}

void PrintDialog::select()
{
  int index=lbPossible->currentItem();
  if(index!=-1)
    {
      select(index);
    } else {
      KApplication::getKApplication()->beep();
    }
}

void PrintDialog::unSelect()
{
  int index=lbSelected->currentItem();
  if(index!=-1)
    {
      unSelect(index);
    } else {
      KApplication::getKApplication()->beep();
    }
}

bool PrintDialog::getSelected(list<string>& keys)
{
  if(selectedKeys.size()!=0)
    {
      keys=selectedKeys;
      return true;
    } else {
      return false;
    }
}

string PrintDialog::getHeader()
{ 
  return i18n("Addressbook overview");
}

string PrintDialog::getFooterLeft()
{
  return i18n("The KDE addressbook."); 
}

string PrintDialog::getFooterRight()
{
  return i18n("Page <p>");
}

PrintDialog::~PrintDialog()
{
}

void PrintDialog::up()
{
  ID(bool GUARD=true);
  LG(GUARD, "PrintDialog::up: "
     "moving current \"selected key\" up.\n");
  REQUIRE(1);
  // ########################################################
  int index;
  string desc;
  string key;
  list<string>::iterator pos;
  // -----
  if(lbSelected->count()==0)
    {
      LG(GUARD, "PrintDialog::up: no entries in listbox.\n");
      return;
    }
  index=lbSelected->currentItem();
  CHECK(index>=0 && (unsigned)index<lbSelected->count());
  if(index==0)
    {
      LG(GUARD, "PrintDialog::up: already first element.\n");
      return;
    }
  // ----- get description from list box:
  desc=lbSelected->text(index);
  // ----- move position in list box:
  lbSelected->removeItem(index);
  lbSelected->insertItem(desc.c_str(), index-1);
  // ----- move position in key-list:
  pos=selectedKeys.begin();
  advance(pos, index);
  key=*pos;
  selectedKeys.erase(pos);
  pos=selectedKeys.begin();
  ::advance(pos, index-1);
  selectedKeys.insert(pos, key);
  // ----- keep the same current item:
  lbSelected->setCurrentItem(index-1);
  // ########################################################
  ENSURE(1);
}

void PrintDialog::down()
{
  ID(bool GUARD=true);
  LG(GUARD, "PrintDialog::down: "
     "moving current \"selected key\" down.\n");
  REQUIRE(1);
  // ########################################################
  int index;
  string desc;
  string key;
  list<string>::iterator pos;
  // -----
  if(lbSelected->count()==0)
    {
      LG(GUARD, "PrintDialog::down: no entries in listbox.\n");
      return;
    }
  index=lbSelected->currentItem();
  CHECK(index>=0 && (unsigned)index<lbSelected->count());
  if((unsigned)index==lbSelected->count()-1)
    {
      LG(GUARD, "PrintDialog::down: "
	 "already last element.\n");
      return;
    }
  // ----- get description from list box:
  desc=lbSelected->text(index);
  // ----- move position in list box:
  lbSelected->removeItem(index);
  lbSelected->insertItem(desc.c_str(), index+1);
  // ----- move position in key-list:
  pos=selectedKeys.begin();
  advance(pos, index);
  key=*pos;
  selectedKeys.erase(pos);
  pos=selectedKeys.begin();
  ::advance(pos, index+1);
  selectedKeys.insert(pos, key);
  // ----- keep the same current item:
  lbSelected->setCurrentItem(index+1);
  // ########################################################
  ENSURE(1);
}

// -----

bool PrintDialog::invariant()
{
  L("PrintDialog::invariant: "
    "checking sanity of object.\n");
  return
    possibleKeys.size()==lbPossible->count() &&
    selectedKeys.size()==lbSelected->count();
}

#include "PrintDialog.moc"
#include "PrintDialogData.moc"
