#include <stdio.h>

#include "call.H"
extern "C" {
#include "libvbox.h"
} ;
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <netinet/in.h>


#include <kconfig.h>
#include <kapp.h>



TCall::TCall( QFileInfo *file ) {

  // figure out which version we are running
  KConfig *conf = kapp->getConfig();
  VboxVersion = conf->readNumEntry( "VboxVersion", 1 );

  if( VboxVersion == 1) {
    
    // check if caller ID is known
    if ( file->fileName().length() > 14 ) {
      CallerID = file->fileName().right( file->fileName().length()-13 );
    }
    else 
      CallerID = "-";
    
    // put date information in a QDate object
    // fiddle the information from the file name
    Date.setYMD( file->fileName().mid( 0, 2 ).toInt(),
		 file->fileName().mid( 2, 2 ).toInt(),
		 file->fileName().mid( 4, 2 ).toInt() );
    
    Time.setHMS( file->fileName().mid(  6, 2 ).toInt(),
		 file->fileName().mid(  8, 2 ).toInt(),
		 file->fileName().mid( 10, 2 ).toInt() );
    
    Length = file->size();

  }
  

  if( VboxVersion == 2) {
    
    vaheader_t vboxheader;

    int fd = open( file->filePath(), O_RDONLY );   // open message
    header_get( fd, &vboxheader );            // read header (vbox library)
    close( fd );
    
    CallerID = vboxheader.callerid;	      // get caller ID from header

    // get time from header ...
    QDateTime d;
    time_t  ts = ntohl( vboxheader.time );
    d.setTime_t( ts );

    // ... copy it in the class members
    Date = d.date();
    Time = d.time();	
    
    Length = get_message_ptime( ntohl( vboxheader.compression ),
				file->size() - sizeof( vaheader_t ) );
    
  }
  
  
  FileName = file->fileName();
  
  // old calls are marked as executables
  IsNew = ! file->isExecutable();
  
};


TCall::~TCall() {
  
};



QString TCall::callerID() { 
  return CallerID; 
};



QDate   TCall::date() { 
  return Date; 
};



QTime   TCall::time() { 
  return Time; 
};



uint    TCall::length() { 
  return Length; 
};



QString TCall::listBoxItem() {

  QString  item;
  char     s[5];
  int      t = 0;
  
  if ( VboxVersion == 1 ) 
    t = Length/3800; // 1 sec occupies ~3800 bytes
  if ( VboxVersion == 2 )
    t = Length;

  item = ( CallerID +"\t" +Date.toString() +"\t" 
	   +Time.toString() +"\t" );
  if ( t%60 < 10 )
    item += sprintf( s, "%1d:0%1d", t/60, t%60);
  else
    item += sprintf( s, "%1d:%2d", t/60, t%60);
  item += s;

  return item; 

};



QString TCall::fileName() { 
  return FileName; 
};



bool    TCall::isNew() { 
  return IsNew; 
};



void    TCall::setCallerID( QString id ) { 
  CallerID = id; 
};



void    TCall::setDate( QDate d ) { 
  Date = d; 
};



void    TCall::setTime( QTime t ) { 
  Time = t; 
};



void    TCall::setLength( uint len ) { 
  Length = len; 
};



void    TCall::setFileName( QString file ) { 
  FileName = file; 
};



void    TCall::setNew( bool state ) { 
  IsNew = state; 
};






