#ifndef config_H
#define config_H

#include <qdialog.h>
#include <qlined.h>
#include <qstring.h>
#include <qradiobt.h>
#include <qbttngrp.h> 

#include <kconfig.h>


struct TConfigData {

  QString  SpoolDir;
  QString  IndirPath;
  int      UpdateInterval;
  int      VboxVersion;
  bool     Hidden;
  QString  ColumnWidth;

};


class TConfig : public QDialog {        

  Q_OBJECT    

public:        
  
  TConfig( QWidget *parent, const char *name, TConfigData *conf );

signals:

  void configChanged( TConfigData *conf );

protected slots:

  void accept();

private:

  TConfigData  *ConfData;
  QLineEdit    *IndirE;
  QLineEdit    *UpdateE;
  QRadioButton *V1;
  QRadioButton *V2;

};    


#endif  // config_H


