/***************************************************************************
                          FILENAME  -  description                              
                             -------------------                                         
    begin                : DATE                                           
    copyright            : (C) YEAR by AUTHOR                         
    email                : EMAIL                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cwizardstep3.h"

CWizardStep3::CWizardStep3(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();

	/*aditional init*/
	setCaption(i18n("karchiveur's wizard last step"));
	
  led1=new KLed(KLed::green,this,"led1");
  led1->setGeometry(160,235,20,20);

  led2=new KLed(KLed::green,this,"led2");
  led2->setGeometry(190,235,20,20);

  led3=new KLed(KLed::green,this,"led3");
  led3->setGeometry(220,235,20,20);

  initLeds();
  	
	connect(&processpath, SIGNAL(receivedStdout (KProcess*, char*, int)), this, SLOT(recueStdout(KProcess*, char*, int)));
	connect(&processpath, SIGNAL(processExited(KProcess*)), this, SLOT(sortieProcess(KProcess*)));

	connect(&processinst, SIGNAL(receivedStdout (KProcess*, char*, int)), this, SLOT(recueStdout(KProcess*, char*, int)));
	connect(&processinst, SIGNAL(processExited(KProcess*)), this, SLOT(sortieProcessInst(KProcess*)));
	
	connect(boutonDemarrer, SIGNAL(clicked()), this, SLOT(slotdetermineTypeOperation()));
			
	connect(boutonAnnuler, SIGNAL(clicked()), this, SLOT(accept()));
	
	makeinstall="";
	operation=-1;
}

CWizardStep3::~CWizardStep3(){
}

/** Recieve Stdout from the running process */
void CWizardStep3::recueStdout(KProcess *proc, char *buffer, int buflen)
{
	QString str=buffer;
	str.truncate(buflen-1);
	mleOutput->insertLine((const char*)str);
	mleOutput->setCursorPosition(mleOutput->numLines(),0);
}

/** End of the process */
void CWizardStep3::sortieProcess(KProcess* process)
{
	led3->setState(KLed::On);
}

/** End of the process */
void CWizardStep3::sortieProcessInst(KProcess* process)
{
	QString str;
	if(operation==CONFIGURATION)
	{	
		operation=COMPILATION;
		led1->setState(KLed::On);
		processinst.clearArguments();
		processinst << make;
		str="-C";
		str+=repbase;
		processinst << (const char*)str;
		if(processinst.start(KProcess::NotifyOnExit,KProcess::AllOutput)==false)
			printf("Pb process\n");		
	}
	else if(operation==COMPILATION)
	{
		operation=INSTALLATION;
		led2->setState(KLed::On);
		if(typeInstallation==2)
		{
			//Don't install
			led3->setState(KLed::On);
			operation=-1;
		}
		else if((operation==INSTALLATION)&&(KMsgBox::yesNo(this,
																												i18n("Warning"),
																												i18n("Compilation is now achieved\nCheck the output NOW for errors\nDo you still want to install as root ?"),
																												8,
																												i18n("Yes"),
																												i18n("No"))==1))
		{
			operation=FININSTALL;
			processinst.clearArguments();

			if(typeInstallation==0)
			{
				processinst << "xterm";
				processinst << "-e";
				processinst << "su";
				processinst << "-c";
				processinst << "\"";
			}
			processinst << make;
			str="-C";
			str+=repbase;
			processinst << (const char*)str;
			processinst << makeinstall;
			if(typeInstallation==0)
			{
				processinst << ";";
				processinst << "echo";
				processinst << "Installation achieved, closing in progress...";
				processinst << ";";
				processinst << "sleep";
				processinst << "4";				
				processinst << "\"";
			}
			if(processinst.start(KProcess::NotifyOnExit,KProcess::Stdout)==false)
				printf("Pb process\n");
		}			
	}
	else if(operation==FININSTALL)led3->setState(KLed::On);	
}

/** Let's start patching ! */
void CWizardStep3::fairePatch()
{
	QDir rep;
	initLeds();
	
	reppatch=KDirDialog::getDirectory(QDir::homeDirPath());

	rep=reppatch;	
	if(!rep.isReadable())
	{
		led1->setColor(KLed::red);
		led1->setState(KLed::On);	
		return;
  }

	if(!rep.cdUp())
	{
		led1->setColor(KLed::red);
		led1->setState(KLed::On);	
		return;
	}
	
	reppatch=rep.path();
	led1->setState(KLed::On);
	repbase=(const char*)strcat((char*)repbase,fichselect);	
	
	processpath.clearArguments();
	processpath << "patch";
	processpath <<"-p0";
	processpath << "-d";
	processpath << reppatch;
	processpath << "-i";
	processpath << repbase;

	if(processpath.start(KProcess::NotifyOnExit,KProcess::AllOutput)==false)
		printf("Pb process\n");
	led2->setState(KLed::On);		
}

void CWizardStep3::setOperation(int op)
{
	typeoperation=op;
}

/* Start the compilation and installation */
void CWizardStep3::faireInstall()
{
	QString str;
  initLeds();

	// Set the path of configure script
	str=repbase;
	str+=config;
		
	operation=CONFIGURATION;
	processinst.clearArguments();
	processinst << "cd";
	processinst << (const char*)repbase; processinst << ";";
	processinst << (const char*) str;
	processinst << (const char*) configopt;
	if(processinst.start(KProcess::NotifyOnExit,KProcess::AllOutput)==false)
		printf("Pb process conf\n");	
}

/** Set various parameters for installation */
void CWizardStep3::setParametres(const char* conf, const char* confopt, const char* mak, const char* makinst, int typeInstall){
	config=conf;
	configopt=confopt;
	make=mak;
	makeinstall=makinst;
	typeInstallation=typeInstall;
}

/** Set all leds to green, state=off */
void CWizardStep3::initLeds()
{
	led1->setState(KLed::Off);
	led1->setColor(KLed::green);
	led2->setState(KLed::Off);
	led2->setColor(KLed::green);
	led3->setState(KLed::Off);
	led3->setColor(KLed::green);		
}

/** Choose if we'll do a patch (op==0) or an install */
void CWizardStep3::slotdetermineTypeOperation()
{
	if(typeoperation==0)
		fairePatch();
	else
		faireInstall();
}
