#ifndef KBOOTSEL_H 
#define KBOOTSEL_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qmessagebox.h>

#include <kwm.h>
#include <kapp.h>
#include <ktmainwindow.h>
#include <kmsgbox.h>
#include <kmsgbox.h>
 
#include "kbootselwidget.h"
#include "liloinfo.h"

class KBootSelWidget;

/**
 * This class serves as the main window for KBootSelector. It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Stefan van den Oord <s.m.vandenoord@student.utwente.nl>
 * @version 0.3
 */
class KBootSel : public KTMainWindow
{
	Q_OBJECT

	public:
		/**
		 * The constructor
		 * @param enableDebug Indicates whether debug information must be printed.
		 */
		KBootSel ( bool enableDebug = false );

		/**
		 * The destructor
		 */
		virtual ~KBootSel();

	public slots:
		void okClicked();
		void cancelClicked();
		void clearClicked();
		void configureClicked();
		void aboutClicked();

		void helpClicked();

	protected slots:
		/**
		 * Recomputes the size of the window according to the position of the toolbar
		 * (i.e. whether it is floating or not).
		 */
		void toolBarMoved();

	protected:

	private:
		bool debug;
		bool toolBarFloating;
		int toolBarHeight, minHeight;

		KConfigBase *config;

		KBootSelWidget *view;
		
		LiloInfo *lilo;

		int showErrorDialog();
		void recomputeMinimumSize();
};

#endif // KBOOTSEL_H 
