#include <iostream.h>

#include "kbootselconfig.h"

KBootSelConfig::KBootSelConfig ( QWidget *parent, const char *name=0, bool globalConfig = false )
	: KConfigWidget ( parent, name )
{
	// Set the name of the configuration file that is to be used
	if ( globalConfig )
		configFileName = QString ( CONFIGFILE );
	else
		configFileName = QString ( LOCALCONFIGFILE );

	// Create the main layout with a border of 10 pixels
	layout = new QVBoxLayout ( this , 10 );

	layout->addStretch ( 2 );

	lab_liloloc = new QLabel ( i18n("Lilo location:"), this );
	lab_liloloc->setMinimumHeight ( lab_liloloc->sizeHint().height() );
	lab_liloloc->setMaximumHeight ( lab_liloloc->sizeHint().height() );
	layout->addWidget ( lab_liloloc );

	lay_liloloc = new QHBoxLayout();
	layout->addLayout ( lay_liloloc );

		// The textfield and browse button are in a separate layout manager
		txt_liloloc = new KLined ( this );
		txt_liloloc->setMinimumHeight ( txt_liloloc->sizeHint().height() );
		txt_liloloc->setMaximumHeight ( txt_liloloc->sizeHint().height() );
		lay_liloloc->addWidget ( txt_liloloc, 2 );

		lay_liloloc->addSpacing ( -5 );

		btn_lilobrowse = new QPushButton ( i18n("Browse..."), this );
		btn_lilobrowse->setMinimumSize ( btn_lilobrowse->sizeHint() );
		btn_lilobrowse->setMaximumSize ( btn_lilobrowse->sizeHint() );
		lay_liloloc->addWidget ( btn_lilobrowse );

	layout->addStretch ( 2 );

	lab_bootmaploc = new QLabel ( i18n("Boot map location:"), this );
	lab_bootmaploc->setMinimumHeight ( lab_bootmaploc->sizeHint().height() );
	lab_bootmaploc->setMaximumHeight ( lab_bootmaploc->sizeHint().height() );
	layout->addWidget ( lab_bootmaploc );

	lay_bootmaploc = new QHBoxLayout();
	layout->addLayout ( lay_bootmaploc );

		// The textfield and browse button are in a separate layout manager
		txt_bootmaploc = new KLined ( this );
		txt_bootmaploc->setMinimumHeight ( txt_bootmaploc->sizeHint().height() );
		txt_bootmaploc->setMaximumHeight ( txt_bootmaploc->sizeHint().height() );
		lay_bootmaploc->addWidget ( txt_bootmaploc, 2 );

		lay_bootmaploc->addSpacing ( -5 );

		btn_bootmapbrowse = new QPushButton ( i18n("Browse..."), this );
		btn_bootmapbrowse->setMinimumSize ( btn_bootmapbrowse->sizeHint() );
		btn_bootmapbrowse->setMaximumSize ( btn_bootmapbrowse->sizeHint() );
		lay_bootmaploc->addWidget ( btn_bootmapbrowse );

	layout->addStretch ( 2 );

	chk_hack = new QCheckBox ( i18n("Use hack to get next boot option from Lilo"), this );
	chk_hack->setMinimumSize ( chk_hack->sizeHint() );
	chk_hack->setMaximumHeight ( chk_hack->sizeHint().height() );
	layout->addWidget ( chk_hack );

	layout->addStretch ( 2 );

	// Activate the layout managers
	layout->activate();

	// Connect the browse buttons
	connect ( btn_lilobrowse, SIGNAL(clicked()), SLOT(browseLilo()) );
	connect ( btn_bootmapbrowse, SIGNAL(clicked()), SLOT(browseBootmap()) );

	// Add the tooltips
	QToolTip::add ( btn_lilobrowse, i18n("Point out the file.") );
	QToolTip::add ( btn_bootmapbrowse, i18n("Point out the file.") );
	QToolTip::add ( txt_liloloc, i18n("Enter the location of the Lilo executable here.") );
	QToolTip::add ( txt_bootmaploc, i18n("Enter the location of Lilo's boot map file here.") );
	QToolTip::add ( chk_hack, i18n("Check this to be able to find out what the next boot option was.") );

	// Initialize the contents of the dialog
	loadSettings();
}

void KBootSelConfig::loadSettings()
{
	QString str;

	// Create a configuration object
	KConfig *config = new KConfig ( configFileName );

	// Set the right group
	config->setGroup ( CONFIGGROUP_LILO );

	// Read the entries and set the window elements to the corresponding values
	str = config->readEntry ( CONFIGKEY_LILOLOC, DEFAULT_LILOLOCATION );
	txt_liloloc->setText ( (const char *)str );

	str = config->readEntry ( CONFIGKEY_BOOTMAPLOC, DEFAULT_BOOTMAPLOCATION );
	txt_bootmaploc->setText ( (const char *)str );

	bool useHack = config->readBoolEntry ( CONFIGKEY_LILOHACK, true );
	chk_hack->setChecked ( useHack );

	// Remove the configuration object
	delete config;
}

void KBootSelConfig::applySettings()
{
	// Create a configuration object
	KConfig *config = new KConfig ( configFileName );

	// Set the right group
	config->setGroup ( CONFIGGROUP_LILO );

	// Write the entries according to the window elements' values
	config->writeEntry ( CONFIGKEY_LILOLOC, txt_liloloc->text() );
	config->writeEntry ( CONFIGKEY_BOOTMAPLOC, txt_bootmaploc->text() );
	config->writeEntry ( CONFIGKEY_LILOHACK, chk_hack->isChecked() );

	// Remove the configuration object
	delete config;
}

void KBootSelConfig::defaultSettings()
{
	// Set the default values
	txt_liloloc->setText ( DEFAULT_LILOLOCATION );
	txt_bootmaploc->setText ( DEFAULT_BOOTMAPLOCATION );
	chk_hack->setEnabled ( true );
}

void KBootSelConfig::browseLilo()
{
	// The code that is executed when the browse button is pressed
	QString str = KFileDialog::getOpenFileName ( txt_liloloc->text() );
	if ( !str.isEmpty() )
		txt_liloloc->setText ( (const char *)str );
}

void KBootSelConfig::browseBootmap()
{
	// The code that is executed when the browse button is pressed
	QString str = KFileDialog::getOpenFileName ( txt_bootmaploc->text() );
	if ( !str.isEmpty() )
		txt_bootmaploc->setText ( (const char *)str );
}
