/***************************************************************************
                          kchmod.h  -  description
                             -------------------
    begin                : Mon Jan 17 20:53:55 EST 2000
    copyright            : (C) 2000 by Jonathan Singer
    email                : jsinger@leeta.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software and can be used or redistributed        *
 *   subject to the included license.                                      *
 *                                                                         *
 ***************************************************************************/

#ifndef KCHMOD_H
#define KCHMOD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <kmenubar.h>
#include <kpopupmenu.h>
#include <view.h>
#include <qcheckbox.h>
#include <qstring.h>
#include <klocale.h>
#include <ktmainwindow.h>


class Kchmod : public KTMainWindow
{
  Q_OBJECT
  public:
    /** constructor */
    Kchmod();
    /** destructor */
    ~Kchmod();
    void setButtons();
		void readArgs();
   public slots:
    void calculateSettings( int );
    void writeSettings();
    void showTooltips();
    void pickFile();
    void useDirectory();
   private:
		QString fileName;

   	KMenuBar *mainMenu;
		KPopupMenu *fileMenu;
		KHelpMenu *khelp;
		view_w *main_view;
		
		
		QCheckBox *i_r_button;
		QCheckBox *i_w_button;
		QCheckBox *i_x_button;
		QCheckBox *u_r_button;
		QCheckBox *u_w_button;
		QCheckBox *u_x_button;
		QCheckBox *g_r_button;
		QCheckBox *g_w_button;
		QCheckBox *g_x_button;
		QCheckBox *o_r_button;
		QCheckBox *o_w_button;
		QCheckBox *o_x_button;
		QLabel *command;		
		QLabel *u_ls;
		QLabel *g_ls;
		QLabel *o_ls;

		QString ls_input;
		
		int id_val;
		int user_val;
		int group_val;
		int other_val;
		bool setuid_set;
		bool recursive_set;
		bool show_tips;
		
		void failed();
		void processFilename();
		

		
};

#endif
