/*
 * pgp2config.h
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PGP2CONFIG_H
#define PGP2CONFIG_H

#include "pgpconfig.h"

#include <ksimpleconfig.h>

class Pgp2Config : public PgpConfig
{
  friend PgpConfig;

public:

  /// stores values
  void    apply();

  /// restores dafault values
  void    setDefault();

  /** return path to the pgp directory **/
  QString pgpPath() const;

  /** set pgp flags **/
  void    setFlag(Flag flag, bool value);
  /** get pgp flags **/
  bool    getFlag(Flag flag) const;

  /** make key the default private key **/
  void    setDefaultKey(QString myname);
  /** return the default key **/
  QString getDefaultKey() const;

  void    setPubring(QString pubring);
  QString getPubring() const;

  void    setSecring(QString secring);
  QString getSecring() const;

  void    setRandseed(QString randseed);
  QString getRandseed() const;

  /** set default pgp comment **/
  void    setComment(QString comment);
  /** get default pgp comment **/
  QString getComment() const;

  /** number of marginaly trusted introducers needed **/
  void    setMarginalsNeeded(int marginals = 2);
  int     getMarginalsNeeded() const;

  /** number of completely trusted introducers needed **/
  void    setCompletesNeeded(int completes = 1);
  int     getCompletesNeeded() const;

  /** select how deep introducers may be nested **/
  void    setCertDepth(int depth = 4);
  int     getCertDepth() const;

  void    setVerbose(int verbose);
  int     getVerbose() const;

protected:
  
  Pgp2Config();
  ~Pgp2Config();

protected:

  static char* FlagStr[];

  bool           flags[8];
  bool           pubring_changed;

  QString        pgp_path;
  QString        comment;
  QString        pubring;
  QString        secring;
  QString        randseed;
  QString        myname;

  int            completes_needed;
  int            marginals_needed;
  int            cert_depth;
  int            verbose;

  KSimpleConfig* pgp_config;
};

#endif
