/*
 * pgpconfig.cpp
 *
 * Copyright (c) 1997 Christian Stueble  stueble@ls6.cs.uni-dortmund.de
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "pgpconfig.h"
#include "pgp2config.h"

#include <kdebug.h>
#include <kapp.h>
#include <kconfig.h>
#include <kmsgbox.h>


// ---------  static member  -----------

PgpConfig* PgpConfig::pgpconfig = 0;

#include <iostream.h>

PgpConfig* PgpConfig::getPgpConfig()
{
  if (PgpConfig::pgpconfig)
    {
      return PgpConfig::pgpconfig;
    }
  else
    {
      KConfig *config = new KConfig(kapp->localconfigdir()+"/kcmpgprc");
      int     version = 0;

      config->setGroup("General");

      version = config->readNumEntry("Version", 0);

      
      if (version == 0)
	{
	  // First start of pgpconfig. Make shure, user has made a copy
	  if (1 != KMsgBox::yesNo(0, "Question", "Attention - this code is ALPHA!\nIt may corrupt your keyring files.\nMake a copy of them!\nContinue?"))
	    exit(0);
	 
	  // the version has to be checked...
	  version = 2;
	  config->writeEntry("Version", version);
	  config->sync();
	}

      delete config;

      switch(version)
	{
	case 2:
	  PgpConfig::pgpconfig = new Pgp2Config;
	  return PgpConfig::pgpconfig;
	  break;
	case 5:
	  debug("Sorry, PGP 5 support not implemented");
	  break;
	default:
	  debug("ERROR: wrong pgp version");
	}
    }

  return 0;
};


// -------------------------------------

PgpConfig::PgpConfig() :
  config(new KConfig(kapp->localconfigdir()+"/kcmpgprc"))
{};

PgpConfig::~PgpConfig()
{
  delete config;
};
