/**************************************************************************
 *
 *  Copyright (C) 1998 Neil Hart (nhart@magma.ca)
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Id: kfiledir.cpp,v 1.4 1998/04/24 17:56:18 nhart Exp $
 *                                                                   
 *************************************************************************/

#include "kfiledir.h"
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <pwd.h>
#include <grp.h>

static char* RCSinfo = "$Id: kfiledir.cpp,v 1.4 1998/04/24 17:56:18 nhart Exp $";

bool KFile::chmod(int mode)
{
	QFileInfo* qfi = new QFileInfo(*this);
	const char* filename = qfi->filePath();
	if (::chmod(filename, mode) == 0)
		return TRUE;
	else
		return FALSE;
}

bool KFile::chown(const char* owner, const char* groupname)
{
	QFileInfo* qfi = new QFileInfo(*this);
	const char* filename = qfi->filePath();

	struct passwd *pw = getpwnam(owner);
	if (!pw)
		return FALSE;
	uid_t ownerid = pw->pw_uid;

	struct group *gp = 0;
	if (groupname)
		gp = getgrnam(groupname);
	gid_t groupid = gp ? gp->gr_gid : -1;
	if (::chown(filename, ownerid, groupid) == 0)
		return TRUE;
	else
		return FALSE;
}

bool KFile::touch()
{
	if (!this->open(IO_WriteOnly))
		return FALSE;
	this->close();
	return TRUE;
}

bool KDir::chmod(const char* dirName, int mode)
{
	if (::chmod(dirName, mode) == 0)
		return TRUE;
	else
		return FALSE;
}

bool KDir::chown(const char* dirName, const char* owner, const char* groupname)
{
	struct passwd *pw = getpwnam(owner);
	if (!pw)
		return FALSE;
	uid_t ownerid = pw->pw_uid;

	struct group *gp = 0;
	if (groupname)
		gp = getgrnam(groupname);
	gid_t groupid = gp ? gp->gr_gid : -1;
	if (::chown(dirName, ownerid, groupid) == 0)
		return TRUE;
	else
		return FALSE;
}
