#ifndef ColorSet_included
#define ColorSet_included

#include <qintdict.h>

#include "../Colorizer.h"
#include "ColorSetData.h"



//////////////////////////////////////////////
class ColorItem : public QListBoxText
{
public:
	ColorItem(const QString& name, const QColor color)
		: QListBoxText(name)		  
	{ Color = color; }
	
	virtual void paint(QPainter* p)
	{
		QFontMetrics fm(p->fontMetrics());
		p->setPen(Color);
		p->drawText(3, (fm.leading()>>1) + fm.ascent(), text());
	}
	
	const QColor& color() const
	{ return Color; }

	
protected:
	QColor Color;
};
//////////////////////////////////////////////



/////////////////////////////////////////////////////////////////////
class ColorSet : public ColorSetData
{
    Q_OBJECT

public:
    ColorSet(Colorizer& col, const QFont& font, QWidget* parent = NULL);
	virtual ~ColorSet();
	
	
protected slots:
	virtual void applyClicked();
	virtual void elemChanged();
	virtual void colorChanged(int);
    virtual void syntaxElementHighlighted(int);


signals:
	void applied();

protected:
	Colorizer& colorizer;
	QVectorT<SyntaxState> LocalSStates;
	QIntDict<ColorItem> ColorTable;
	
	void insertColorItem(const char* name, const QColor& color);	
};
/////////////////////////////////////////////////////////////////////



#endif // ColorSet_included

