//
// findreplace.C
//
// written by Michael Riedel <Michael.Riedel@gmx.de>
// based on KEdits Search/Replace routines
//

#include <kapp.h>
#include <qcombo.h>
#include <qlined.h>
#include <qvalidator.h>

#include "FindReplace.h"
#include "FindReplace.moc"
#include "EditorSectionName.h"

#define MAX_FIND_HISTORY 10		// maximum number of items in find/replace combo
QString findHistory = "FindHistory";



////////////////////////////////////////////////////////////////////
//
// Find Dialog
//

KEdSrch::KEdSrch(QWidget *parent, const char *name)
    : QDialog(parent, name)
{

    this->setFocusPolicy(QWidget::StrongFocus);
    frame1 = new QGroupBox(klocale->translate("Find"), this, "frame1");
    
    value = new QComboBox(true, this, "value");
    value->setFocus();

    sensitive = new QCheckBox(klocale->translate("Case Sensitive"), this, "case");
    direction = new QCheckBox(klocale->translate("Find Backwards"), this, "direction");
    sensitive->adjustSize();
    direction->adjustSize();

    ok = new QPushButton(klocale->translate("Find"), this, "find");
    connect(ok, SIGNAL(clicked()), this, SLOT(ok_slot()));
    ok->setDefault(true);

    cancel = new QPushButton(klocale->translate("Done"), this, "cancel");
    connect(cancel, SIGNAL(clicked()), this, SLOT(done_slot()));

    setFixedSize(330, 130);
    
    QStrList l;
	KConfig* kconfig = kapp->getConfig();
	const char* group = kconfig->group();	
	kconfig->setGroup(EditorSectionName);
	kconfig->readListEntry(findHistory, l);
	kconfig->setGroup(group);
	
	value->insertStrList(&l);
}

void KEdSrch::focusInEvent( QFocusEvent *)
{
    value->setFocus();
}

QString KEdSrch::getText() 
{ 
	return value->currentText(); 
}

void KEdSrch::setText(const QString& string)
{
	insertSearchText(string);
}

void KEdSrch::done_slot()
{
		// copy the currenty displayed text into the listbox, before
		// its values are saved in the config file:
  	QString text = value->currentText();
  	if (!text.isEmpty())
		insertSearchText(text);
	
		// write last MAX_FIND_HISTORY entries to Config object:
	QStrList l;
	int num = QMIN(value->count(), MAX_FIND_HISTORY);
	for(int i = 0; i < num; i++)
	{
			// since QStrlists are written to the config with separating commas, we need to encode these in
			// the search strings:
		QString v = value->text(i);
/*		
		int index = v.find(',');
		while(index != -1)
		{
			v.insert('\\');
			index = v.find(index + 2);	// +1 for the inserted <\>, +1 for the char following the <,>
		}
*/		
		l.append(v);
	}

	KConfig* kconfig = kapp->getConfig();
	const char* group = kconfig->group();	
	kconfig->setGroup(EditorSectionName);
	kconfig->writeEntry(findHistory, l);
	kconfig->setGroup(group);
	
  	emit search_done_signal();
}


bool KEdSrch::case_sensitive()
{
  	return sensitive->isChecked();
}

bool KEdSrch::directionIsBackward()
{
  	return direction->isChecked();
}

void KEdSrch::ok_slot()
{
  	QString text = value->currentText();

  	if (!text.isEmpty())
	{
		insertSearchText(text);
		emit search_signal();
	}
}

void KEdSrch::resizeEvent(QResizeEvent *)
{
    frame1->setGeometry(5, 5, width() - 10, 80);
    cancel->setGeometry(width() - 80, height() - 30, 70, 25);
    ok->setGeometry(10, height() - 30, 70, 25);
    value->setGeometry(20, 25, width() - 40, 30);
    sensitive->setGeometry(20, 55, 130, 25);
    direction->setGeometry(width() - 20 - 130, 55, 130, 25);
}

void KEdSrch::insertSearchText(const QString& text)
{
		// if previous search text was different...
	if(value->text(0) != text)
	{
		if(value->count() > MAX_FIND_HISTORY)
			value->removeItem(value->count() - 1);
				
		value->insertItem(text, 0); // ...we add the new search text at the combo's top
		value->setCurrentItem(0);   // ...and select the item again!
	}
}


////////////////////////////////////////////////////////////////////
//
//  Replace Dialog
//

KEdReplace::KEdReplace(QWidget *parent, const char *name)
    : QDialog(parent, name,FALSE)
{
    this->setFocusPolicy(QWidget::StrongFocus);

    frame1 = new QGroupBox(klocale->translate("Find:"), this, "frame1");

    value = new QLineEdit( this, "value");
    value->setFocus();
    connect(value, SIGNAL(returnPressed()), this, SLOT(ok_slot()));

    replace_value = new QLineEdit( this, "replac_value");
    connect(replace_value, SIGNAL(returnPressed()), this, SLOT(ok_slot()));

    label = new QLabel(this,"Rlabel");
    label->setText(klocale->translate("Replace with:"));

    sensitive = new QCheckBox(klocale->translate("Case Sensitive"), this, "case");
    sensitive->setChecked(TRUE);

    direction = new QCheckBox(klocale->translate("Find Backwards")
			      , this, "direction");
    
    ok = new QPushButton(klocale->translate("Find"), this, "find");
    connect(ok, SIGNAL(clicked()), this, SLOT(ok_slot()));

    replace = new QPushButton(klocale->translate("Replace"), this, "rep");
    connect(replace, SIGNAL(clicked()), this, SLOT(replace_slot()));

    replace_all = new QPushButton(klocale->translate("Replace All"), this, "repall");
    connect(replace_all, SIGNAL(clicked()), this, SLOT(replace_all_slot()));

    cancel = new QPushButton(klocale->translate("Done"), this, "cancel");
    connect(cancel, SIGNAL(clicked()), this, SLOT(done_slot()));

    setFixedSize(330, 180);

}


void KEdReplace::focusInEvent( QFocusEvent *)
{
    value->setFocus();
    value->selectAll();
}

QString KEdReplace::getText() { return value->text(); }

QString KEdReplace::getReplaceText() { return replace_value->text(); }

void KEdReplace::setText(QString string) 
{ 
  value->setText(string); 
}

void KEdReplace::done_slot()
{
  emit replace_done_signal();
}


void KEdReplace::replace_slot()
{
  emit replace_signal();
}

void KEdReplace::replace_all_slot()
{
  emit replace_all_signal();
}


bool KEdReplace::case_sensitive()
{
  return sensitive->isChecked();
}


bool KEdReplace::directionIsBackward()
{
  return direction->isChecked();
}


void KEdReplace::ok_slot()
{
  QString text;
  text = value->text();

  if (!text.isEmpty())
    emit find_signal();
}

void KEdReplace::resizeEvent(QResizeEvent *)
{
    frame1->setGeometry(5, 5, width() - 10, 135);

    cancel->setGeometry(width() - 80, height() - 30, 70, 25);
    ok->setGeometry(10, height() - 30, 70, 25);
    replace->setGeometry(85, height() - 30, 70, 25);
    replace_all->setGeometry(160, height() - 30, 85, 25);

    value->setGeometry(20, 25, width() - 40, 25);
    replace_value->setGeometry(20, 80, width() - 40, 25);
    
    label->setGeometry(20,55,80,20);
    sensitive->setGeometry(20, 110, 130, 25);
    direction->setGeometry(width()- 20 - 130, 110, 130, 25);
}



////////////////////////////////////////////////////////////////////
//
//  Goto Dialog
//

KEdGotoLine::KEdGotoLine( QWidget *parent, const char *name, int numLines)
	: QDialog( parent, name, TRUE )
{
	frame = new QGroupBox( klocale->translate("Goto Line"), this );
	
	lineNum = new QLineEdit(this, klocale->translate("Goto Line"));
	lineNum->setValidator(new QIntValidator(1, numLines, this));
	
	setFocusPolicy( QWidget::StrongFocus );
	connect(lineNum, SIGNAL(returnPressed()), this, SLOT(accept()));

	ok = new QPushButton(klocale->translate("Go"), this );
	cancel = new QPushButton(klocale->translate("Cancel"), this ); 

	connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));
	connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
	resize(300, 120); 
}

void KEdGotoLine::focusInEvent( QFocusEvent *)
{
    lineNum->setFocus();
    lineNum->selectAll();
}

void KEdGotoLine::resizeEvent(QResizeEvent *)
{
    frame->setGeometry(5, 5, width() - 10, 80);
    cancel->setGeometry(width() - 80, height() - 30, 70, 25);
    ok->setGeometry(10, height() - 30, 70, 25);
    lineNum->setGeometry(20, 35, width() - 40, 25);
}

