/***************************************************************************
                          kcpuinfo.cpp  -  description                              
                             -------------------                                         
    begin                : Thu Jun 10 12:27:40 CEST 1999
                                           
    copyright            : (C) 1999 by Enrico Schulz                         
    email                : emmy@online.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kcpuinfo.h"
#include <qpushbutton.h>
#include <ktablistbox.h>
#include <kmsgbox.h>

Kcpuinfo::Kcpuinfo(QWidget*parent,const char* name):QWidget(parent,name){
initializewindow();
}
Kcpuinfo::~Kcpuinfo(){
}

void Kcpuinfo::initializewindow()
{
//  system("echo initialize");
  this->resize(330, 300);
  tablistbox = new KTabListBox(this, "tablistbox");
  tablistbox->setGeometry(0,0,330,270);
  tablistbox->setNumCols(2);
  tablistbox->setColumn(0, i18n("Information"), 100);
  tablistbox->setColumn(1, i18n("Value"), 225);
  readfromfile(tablistbox);

  infobutton = new QPushButton(this, "infobutton");
  infobutton->setGeometry(0, 270, 60, 30);
  infobutton->setText("&About");
  connect(infobutton, SIGNAL(clicked()), SLOT(infoclicked()));

  exitbutton = new QPushButton(this, "exitbutton");
  exitbutton->setGeometry(270, 270, 60, 30);
  exitbutton->setText("&Exit");
  connect(exitbutton, SIGNAL(clicked()), SLOT(exitclicked()));
//  system("echo initialized ended");
}

void Kcpuinfo::exitclicked()
{
  close();
}

void Kcpuinfo::infoclicked()
{
  KMsgBox::message(this, i18n("Info to Kcpuinfo"), i18n("Kcpuinfo show your cpuinformation"));
}
void Kcpuinfo::readfromfile(KTabListBox *tablistbox)
{
  char splitchar = ':';
  QString str;
  char buf[512];
  tablistbox->setSeparator(splitchar);
  QFile *file = new QFile("/proc/cpuinfo");

  if (!file->open(IO_ReadOnly))
  {
    delete file;
  }
  while (file->readLine(buf, sizeof(buf)-1)>0)
  {
    if (strlen(buf))
    {
      char *p=buf;
      if (splitchar!=0)
      while (*p)
      {
        if (*p==splitchar)
        {
          *p++ == ' ';
          while (*p == ' ') ++p;
          *(--p) = splitchar;
          ++p;
        }
        else ++p;
      }
      tablistbox->insertItem(buf);
    }
  }
  file->close();
  delete file;
}
