#ifndef _KEDIT_H_
#define _KEDIT_H_

#include <ktopwidget.h>
#include <kstatusbar.h>
#include <kprocess.h>
#include <ktreelist.h>
#include <qlist.h>
#include <qpushbt.h>
#include <qlistbox.h>
#include <qchkbox.h>
#include <qlined.h>
#include "imap.h"
class KcyradmDlg : public KTopLevelWidget
{
    Q_OBJECT;

public:
    KcyradmDlg
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );
    class CUserpermissions {
  	  public:
	  QString username;
	  QString permissions;
	};
	 
    SetupMainMenuBar();
 
    void SetupToolBar();
    void DestroyToolBar();

    void SetupStatusBar();
    void DestroyStatusBar();
    
    void SetupListBox();
    void DestroyListBox();
 
    void SetupTreeList();
    void DestroyTreeList();
    
    void CreatePathRecursive(char *path, KTreeListItem* item);
    KTreeListItem *findByName(KTreeListItem *start, QString name);
    void decodeACL(const char *acl);
    void encodeACL(char *buffer, int bufsize);
    void getCheckBoxes();
    void SetCheckBoxes();
    void Interface();
    void findUserInQList(const char *username, const char *permissions );
    void addFolder(const char* foldername);
    //void removeFolder(const char*foldername, const char*adminuser);
    virtual ~KcyradmDlg();
	
private:
 
	QList<CUserpermissions> rights;
	/* Der akuelle Ordner in dem wir uns befinden */
	QString folder;
	
	QString AdminUser;
	QString ImapServer;
	
	/* Buttons */

	QPushButton *ApplyButton;
	QPushButton *DeleteUser;
	QPushButton *AddUser;

	QLineEdit *Username;
	
	/* Bools*/
	int holdall;
	int LpcCommand;
	
	int l,r,s,w,i,p,c,d,a;
	
	QString LpqBuffer;
	QString LpcBuffer;
	
    	/* MainMenuBar */
    	KMenuBar *menubar;
	
    	/* Menus */
    	QPopupMenu *file;
	QPopupMenu *edit;
	QPopupMenu *options;
	QPopupMenu *help;
	
	/* ToolBar */

	KToolBar *toolbar;
	int toolbar1;

#define ID_LINE_COLUMN 1
#define ID_INS_OVR 2
#define ID_GENERAL 3


	ImapClient *xImapClient;
	
	
	/* TreeList */

	KTreeList* TreeList;
	
	/* StatusBar */
	KStatusBar* statusbar;
	
	/* Object for keys */

	QAccel *accel;
	
	/* QListBox */

	QListBox *ListBox;

	/* QComboBox */

	QComboBox *ComboBox;
	
	/* KProcess */

	KProcess *lpq;
	KProcess *lpc;
	KProcess *lprm;
	
	/* CheckBoxes */
	
	QCheckBox *lookup;
	QCheckBox *read;
	QCheckBox *store_seen;
	QCheckBox *write;
	QCheckBox *insert;
	QCheckBox *post;
	QCheckBox *create;
	QCheckBox *store_delete;
	QCheckBox *administer;

	


	
	
	
	
	
public slots:
    	void getACL(const char* username);
 	void ButtonClicked();
	void DeleteUserClicked();
	void AddUserClicked();
	void AddFolder();
	void RemoveFolder();

	void SetupCyradm();
	/* Filemenu Items */

	void PrinterMenuExit();
	
	/* Editmenu Items */

	void EditMenuUndo();
	void EditMenuCut();
	void EditMenuCopy();
	void EditMenuPaste();
	
	/* Optionsmenu Items */

	void OptionsMenuConfigure();
	
	/* Helpmenu Items */
	void HelpMenuAbout();
	void HelpMenuHelp();
	
	void TreeListhighlighted(int index);
	
	/* slot for programms */
	/* Do not edit yourself! */
	//@{BEGIN_INTERFACE 
	//	void UpdateListBox();
	//	void UpdateStatusBar();
	//	void Leavekvbox();
	//		void ReReadList();
	//@}END_INTERFACE 
	
protected slots:
	
};
#endif
