#include "kdddlldlg.h"

#include "typelayout.h"

#include <qstrlist.h>
#include <qlistbox.h>
#include <qcombobox.h>

#include <kdebug.h>


KDDDLLDlg::KDDDLLDlg( KDDDLLTagList* tagList, QWidget* _parent, const char *_name ) :
    QDialog( _parent, _name )
{
    const char *name = (*tagList)[ 0 ]->attr.getVal( "NAME", "unnamed" );
    TLForm *ktlform= new TLForm(  name, "", this );
    ktl= ktlform->layout;
    tagToLayout( tagList );
    ktl->activate();
};

KDDDLLDlg::~KDDDLLDlg()
{
}

void KDDDLLDlg::tagToLayout( KDDDLLTagList *tagList )
{
    QStrList  items;
    /** we need this here to save the attributes wich are not applied
      * to the dialog within the tag they appear
      * e.g. <LIST><LI>.., a lot of list item tags ...</LI></LIST>
      */
    QString   name;
    int       index   = -1;
    int       colspan = 0;
    int       rowspan = 0;
    int       minrows = 5;

    // pure temporaries
    TLObj     *obj;
    KDDDLLTag *tag;
    
    for( unsigned int i = 0; i < tagList->count(); i++ )
    {
        tag = (*tagList)[ i ];
        const char *ID = tag->attr.getVal( "NAME" );
        switch( tag->index )
        {
            case TAG_KDDDL:
                break;

            case TAG_E_KDDL:
                break;

            case TAG_GROUP:
                ktl->addGroup( ID, tag->attr.getVal( "TITLE" ), tag->attr.getVal( "BORDER", false ) );
                break;

            case TAG_E_GROUP:
            case TAG_E_BOOK:
            case TAG_E_PAGE:
                ktl->endGroup();
                break;
 
            case TAG_BOOK:
                ktl->addBook( ID );
                break;

            case TAG_PAGE:
                ktl->addPage( ID, tag->attr.getVal( "TITLE" ) );
                break;

            case TAG_LABEL:
                ktl->addLabel( ID, tag->attr.getVal( "TEXT" ) );
                ktl->setSpawn( ID, tag->attr.getVal( "COLSPAN", 1 ), tag->attr.getVal( "ROWSPAN", 1 ) );
                break;

            case TAG_BUTTON:
                ktl->addButton( ID, tag->attr.getVal( "TEXT" ) );
                ktl->setSpawn( ID, tag->attr.getVal( "COLSPAN", 1 ), tag->attr.getVal( "ROWSPAN", 1 ) );
                break;

            case TAG_CHECKBOX:
                ktl->addCheckBox( ID, tag->attr.getVal( "TEXT" ), tag->attr.getVal( "CHECKED", false ) );
                ktl->setSpawn( ID, tag->attr.getVal( "COLSPAN", 1 ), tag->attr.getVal( "ROWSPAN", 1 ) );
                break;

            case TAG_RADIOBUTTON:
                ktl->addRadioButton( ID, tag->attr.getVal( "GROUP" ), tag->attr.getVal( "TEXT" ), tag->attr.getVal( "CHECKED", false ), tag->attr.getVal( "ID", -1 ) );
                ktl->setSpawn( ID, tag->attr.getVal( "COLSPAN", 1 ), tag->attr.getVal( "ROWSPAN", 1 ) );
                break;

            case TAG_LINEEDIT:
                // Add a MIN MAX tag to a TYPE="int" LineEdit
                if( strcasecmp( tag->attr.getVal( "TYPE", "TEXT" ), "INT" ) )
                     ktl->addLineEdit( ID, tag->attr.getVal( "TEXT" ), tag->attr.getVal( "MAXLENGTH", -1 ) );
                else
                     ktl->addIntLineEdit( ID, tag->attr.getVal( "TEXT" ), tag->attr.getVal( "MAXLENGTH", -1 ) );
                ktl->setSpawn( ID, tag->attr.getVal( "COLSPAN", 1 ), tag->attr.getVal( "ROWSPAN", 1 ) );
                break;

            case TAG_LISTBOX:
            case TAG_COMBOBOX:
                for( ; !items.isEmpty(); items.removeFirst() );
                name    = ID;
                index   = tag->attr.getVal( "INDEX",  -1 );
                colspan = tag->attr.getVal( "COLSPAN", 1 );
                rowspan = tag->attr.getVal( "ROWSPAN", 1 );
                minrows = tag->attr.getVal( "MINROWS", 5 );
                break;

            case TAG_E_LISTBOX:
                obj = ktl->addListBox( name, &items, minrows );
                if( index != -1 ) ( (QListBox*)( obj->widget ) )->setCurrentItem( index );
                ktl->setSpawn( name, colspan, rowspan );
                break;

            case TAG_E_COMBOBOX:
                obj = ktl->addComboBox( name, &items );
                if( index != -1 ) ( (QComboBox*)( obj->widget ) )->setCurrentItem( index );
                ktl->setSpawn( name, colspan, rowspan );
                break;

            case TAG_LI:
                items.append( tag->attr.getVal( "TEXT" ) );
                break;

            case TAG_BR:
                ktl->newLine();
                break;

            case TAG_SKIP:
                ktl->skip();
                break;

            default:
                // We are in problem
                KDEBUG2( KDEBUG_ERROR, 1, "Unknown tag <%s> index %i", ID, tag->index );
                break;
        }
    }
}

