#include <stdio.h>

// #define DEBUGME

#ifdef DEBUGME
#ifndef TIMESTAMP
#define dprintf(format, args...) \
   do \
   { \
     fprintf( stdout, "<%s>:<%s>:<%d>:",__FILE__,__PRETTY_FUNCTION__, __LINE__ );\
     fprintf( stdout, format, ## args );\
   } while (0)
#else				/* #ifndef TIMESTAMP */
#include <stdio.h>
#include <string.h>
#include <time.h>
#define dprintf(format, args...) \
   do \
   { \
     time_t t;\
     char *timeStr;\
     t=time((time_t*)0);\
     timeStr=ctime( &t);\
     timeStr[strlen(timeStr)-1]='\0';\
     fprintf( stdout, "<%s>:<%s>:<%d>:<%s>::",__FILE__,__PRETTY_FUNCTION__, __LINE__, timeStr );\
     fprintf( stdout, format, ## args );\
   } while (0)
#endif				/* #ifndef TIMESTAMP */
/* 
   while (0)\
   fflush( stdout );
 */
#else				/* #ifdef DEBUGME */
#define dprintf(format, args...)  ;
#endif

#define tprintf(format, args...) \
   do \
   { \
     time_t t;\
     char *str;\
     t=time((time_t*)0);\
     str=ctime( &t);\
     str[strlen(str)-1]='\0';\
     fprintf( stdout, "<%s>:<%s>:<%d>:<%s>::",__FILE__,__PRETTY_FUNCTION__, __LINE__, str );\
     fprintf( stdout, format, ## args );\
   } while (0)
