#!/bin/bash

len=$(expr length $0)
len=$(expr $len - 8 )
dir=$(expr substr $0 1 $len )
dir=$(echo "$dir")

cd $dir/../../program

clear

wmsg="WARNING: Your sources WON'T be recompiled,\nwe'll deb8 the latest COMPILED version!"

kdialog --msgbox "$wmsg" || xmessage "$wmsg" || dialog --msgbox "$wmsg"

for tstfile in $(ls *)
do
	if (test -x $tstfile)
	then
		echo "Running $tstfile in kdbg"
		kdbg ./$tstfile
		exit 0
	fi
done

emsg="No executable file. You must compile your program before you can run it!"

kdialog --msgbox "$emsg" || xmessage "$emsg" || dialog --msgbox "$emsg"

exit 2