/*************************************************************************
 *                                                                       *
 *  KDu - KDisk Free V0.9.5                                              *
 *                                                                       *
 * Copyright(c) 1998-99 Christian Poulter.                               *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to virtual-dynamics@gmx.net                                    *
 *                                                                       *
 *************************************************************************/

#ifndef KDCONFIGWIDGET_H
#define KDCONFIGWIDGET_H

#include "kdconfig.h"

#include <qgroupbox.h>

#include <kcolorbtn.h>
#include <kiconloaderdialog.h>
#include <klined.h>
#include <kspinbox.h>
#include <kwizard.h>

class KDConfigWidget : public KDialog{
	Q_OBJECT
public:
	KDConfigWidget(QWidget *parent=0, const char *name=0, KDConfig *cfg=0);
	~KDConfigWidget();
	void resizeEvent(QResizeEvent *);

private:
	KDConfig		*config;

	KLined			*dock_pathes[4];

	QLabel			*iconLabelMinix;
	QLabel			*iconLabelExt2;
	QLabel			*iconLabelVFatFD;
	QLabel			*iconLabelFVatHD;
	QLabel			*iconLabelNFS;
	QLabel			*iconLabelSMBFS;
	QLabel			*iconLabelISO9660;
	QLabel			*iconLabelMSDos;
	QLabel			*iconLabelHFS;
	QLabel			*iconLabelUnknown;
	QLabel			*iconLabelUnmounted;

	QLabel			*label_color_free;
	QLabel			*label_color_full;
	QLabel			*label_color_unmounted;

	QPushButton		*button_okay;
	QPushButton		*button_cancel;

	KNumericSpinBox		*update_freq;

	KColorButton		*color_free;
	KColorButton		*color_full;
	KColorButton		*color_unmounted;

	QGroupBox		*gb_icons;
	QGroupBox		*gb_pathes;
	QGroupBox		*gb_update;
	QGroupBox		*gb_color;

	KIconLoaderButton	*iconButtonMinix;
	KIconLoaderButton	*iconButtonExt2;
	KIconLoaderButton	*iconButtonVFatFD;
	KIconLoaderButton	*iconButtonVFatHD;
	KIconLoaderButton	*iconButtonNFS;
	KIconLoaderButton	*iconButtonSMBFS;
	KIconLoaderButton	*iconButtonISO9660;
	KIconLoaderButton	*iconButtonMSDos;
	KIconLoaderButton	*iconButtonHFS;
	KIconLoaderButton	*iconButtonUnknown;
	KIconLoaderButton	*iconButtonUnmounted;

private slots:
	void 			slot_button_okay();
	void 			slot_button_cancel();

signals:
	void			newConfig();
};

#endif


