/***********************************************************************
**
**   airport.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef AIRPORT_H
#define AIRPORT_H

#include <singlepoint.h>
#include <runway.h>

/**
  * This class is used for handling airports. The object can be one of
  * Airport, MilAirport, CivMilAirport, Airfield, ClosedAirfield,
  * CivHeliport, MilHeliport, AmbHeliport.
  *
  * @see BaseMapElement#objectType
  *
  * @author Heiner Lamprecht, Florian Ehinger
  * @version 0.1
  */
class Airport : public SinglePoint
{
 public:
  /**
    * Creates a new Airport-object. n is the name of the airport, a is the alias,
    * t is the typeID, latPos and lonPos give the position, elev is the elevation
    * and f the frequency.
    */
  Airport(QString n, QString a, unsigned int t, long latPos, long lonPos,
              unsigned int elev, QString f, bool vdf = false,
              struct runway* rwDat = 0, unsigned int rwN = 0);
  ~Airport();
  /**
    * Draws the element into the given painter.
    */
  virtual void drawMapElement(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon);
  /**
    * Virtual function for writing the element-data into the given
    * binary-map-file.
    */
  virtual bool writeElementBin(const char* fileName);
  /**
    * Virtual function for writing the element-data into the given
    * ascii-map-file.
    */
  virtual bool writeElementAscii(const char* fileName);
  /**
    * Used for defining the surface of a runway.
    */
  enum Surface {NotSet, Grass, Asphalt, Concrete};

 private:
  /** The alias of the airport. */
  QString alias;
  /** The elevation */
  unsigned int elevation;
  /** The frequency */
  QString frequency;
  /** */
  bool vdf;
  /** Contains the runway-data. */
  struct runway* rwData;
  /** Contains the number of runways. */
  unsigned int rwNum;
};

#endif
