/***********************************************************************
**
**   elevpoint.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef ELEVPOINT_H
#define ELEVPOINT_H

#include <singlepoint.h>

/**
  * This class is used for all mapelements, that have a elevation-value.
  * The object can be one of: Outlanding, Obstacle, LightObstacle,
  * ObstacleGroup, LightObstacleGroup, Spot, Pass.
  *
  * @see BaseMapElement#objectType
  *
  * @author Heiner Lamprecht, Florian Ehinger
  * @version 0.1
  */

class ElevPoint : public SinglePoint
{
 public:
  /**
    * Creates a new elevpoint.
    */
  ElevPoint(QString n, unsigned int t, long latPos = 0,
            long lonPos = 0, unsigned int elev = 0);
  /** */
  ~ElevPoint();
  /**
    * Draws the element into the given painter.
    */
  virtual void drawMapElement(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon);
  /**
    * Virtual function for writing the element-data into the given
    * binary-map-file.
    */
  virtual bool writeElementBin(const char* fileName);
  /**
    * Virtual function for writing the element-data into the given
    * ascii-map-file.
    */
  virtual bool writeElementAscii(const char* fileName);

 private:
  unsigned int elevation;
};

#endif
