/***********************************************************************
**
**   glidersite.cpp
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#include "glidersite.h"

#include <mapcalc.h>

#include <kapp.h>
#include <kiconloader.h>
#include <qdatastream.h>
#include <qfile.h>
#include <qtextstream.h>

bool GliderSite::writeElementBin(const char* fileName)
{
  QFile outputFile(fileName);
  if(!outputFile.open(IO_WriteOnly | IO_Append)) {
    return false;
  }
  QDataStream out(&outputFile);

  out << (Q_UINT8) typeID;
  out << (const char*) name;
  out << (Q_INT32) latitude;
  out << (Q_INT32) longitude;
  out << (Q_UINT16) elevation;
  out << (const char*) frequency;
  out << (Q_UINT8) winch;
  out << (Q_UINT8) isWaypoint;
  out << (Q_UINT8) rwNum;
  for(unsigned int i = 0; i < rwNum; i++) {
    out << (Q_UINT8) rwData[i].direction;
    out << (Q_UINT16) rwData[i].length;
    out << (Q_UINT8) rwData[i].surface;
  }
  outputFile.close();

  return true;
}

bool GliderSite::writeElementAscii(const char* fileName)
{
  QFile mapFile("/tmp/kflog.out");
  if(!mapFile.open(IO_ReadWrite)) {
    return false;
  }
  mapFile.at(mapFile.size());
  QTextStream mapOut(&mapFile);

  mapOut << "[NEW]\n"
         << "TYPE=" << typeID << endl
         << "NAME=" << name << endl
         << "AT=" << latitude << " " << longitude << endl
         << "ELEVATION=" << elevation << endl
         << "FREQUENCY=" << frequency << endl
         << "WINCH=" << (unsigned int) winch << endl
         << "WAYPOINT=" << (unsigned int) isWaypoint << endl;
  for(unsigned int i = 0; i < rwNum; i++) {
    mapOut << "RUNWAY=" << rwData[i].direction << " "
           << rwData[i].length << " "
           << rwData[i].surface << endl;
  }
  mapOut << "[END]\n";
  mapFile.close();

  return true;
}

void GliderSite::drawMapElement(QPainter* targetPainter,
          double dX, double dY, long mapCenterLon)
{
  extern double _scale[];
  extern double _currentScale;
  double lat, lon, projX, projY, drawX, drawY;

  /********************************************************************
   *                                                                  *
   * ACHTUNG: Alle kleinen Objekte knnen prinzipiell                 *
   * Wegpunkte werden! Dies mu noch irgendwie implementiert werden!  *
   *                                                                  *
   ********************************************************************/

  lat = numToRad(latitude);
  lon = numToRad(longitude - mapCenterLon);

  projX = calc_X_Lambert(lat,lon);
  projY = calc_Y_Lambert(lat,lon);

  drawX = projX * RADIUS / _currentScale + dX;
  drawY = projY * RADIUS / _currentScale + dY;

  // ACHTUNG: Alle Icons mssen die gleiche Gre bekommen!
//  QPixmap* pixmap;

  targetPainter->setPen(QPen(QColor(0,0,0), 2));
  char* kflog_dir = "/kflog/map";
  if(_currentScale > _scale[3]) {
    kflog_dir = "/kflog/map/small";
  }
/*
  if(map != 0) {
    map->xPos[i] = (int) drawX;
    map->yPos[i] = (int) drawY;
  }
*/
  if(winch) {
    targetPainter->drawPixmap(drawX - 16, drawY - 16,
       Icon(KApplication::kde_datadir() + kflog_dir + "/glider.xpm"));
  } else {
    targetPainter->drawPixmap(drawX - 16, drawY - 16,
       Icon(KApplication::kde_datadir() + kflog_dir + "/glider2.xpm"));
  }
}

GliderSite::GliderSite(QString n, long latPos, long lonPos,
              unsigned int elev, QString f, bool w = false,
              struct runway* rwDat = 0, unsigned int rwN = 0)
    : SinglePoint(n, Glidersite, latPos, lonPos)
{
  elevation = elev;
  frequency = f;
  winch = w;
  rwData = rwDat;
  rwNum = rwN;
}

GliderSite::~GliderSite()
{

}
