/***********************************************************************
**
**   lineelement.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef LINEELEMENT_H
#define LINEELEMENT_H

#include <basemapelement.h>

/**
  * Class used for all elements, which consist of a pointarray.
  * The object can be one of: [Huge, Big, Mid, Small]City,
  * [Mid, Small]Road, Railway, AerialRailway, [Big, Mid, Small]Lake,
  * [Big, Mid, Small]River, Coast.
  *
  * Consists of a name and the list of coordinates.
  *
  * @see BaseMapElement#objectType
  *
  * @author Heiner Lamprecht, Florian Ehinger
  * @version 0.1
  */

class LineElement : public BaseMapElement
{
 public:
  /**
    * Creates a new mapelement.
    */
  LineElement(QString n, unsigned int t, unsigned int length,
              long* latList, long* lonList);
  LineElement(QString n, unsigned int t);
  /** */
  ~LineElement();
  /**
    * Draws the element into the given painter.
    */
  virtual void drawMapElement(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon);
  /**
    * Virtual function for writing the element-data into the given
    * binary-map-file.
    */
  virtual bool writeElementBin(const char* fileName);
  /**
    * Virtual function for writing the element-data into the given
    * ascii-map-file.
    */
  virtual bool writeElementAscii(const char* fileName);
  /**
    * Sets the list of coordinates.
    */
  virtual void setLocList(long* latList, long* lonList);

 protected:
  /**
    * The name of the mapelement.
    */
  QString name;
  /**
    * The latitude.
    */
  long* latitude;
  /**
    * The longitude.
    */
  long* longitude;
  /**
    * The number of coordinates.
    */
  unsigned int locLength;
};

#endif
