/***********************************************************************
**
**   mapfile.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef MAPFILE_H
#define MAPFILE_H

#include <mapcontents.h>

/**
  * Reads a KFLog-ASCII-Map-File (e.g. produced with the digitizer)
  * and converts it into a binary file.
  */
void ascii2bin();

/**
  * Reads a binary map-file and converts it into a KFLog-ASCII-Map-File.
  */
void bin2ascii();

/**
  * Reads the given ascii-file.
  */
bool readAsciiFile(const char* fileName, MapContents* mContents);

/**
  * Reads the given binary-file.
  */
bool readBinaryFile(const char* fileName, MapContents* mContents);

/**
  * Writes all the map-data into an ASCII-File.
  */
bool writeAsciiFile(const char* fileName, MapContents* mContents);

/**
  * Writes all the map-data into a binary-File.
  */
bool writeBinaryFile(const char* fileName, MapContents* mContents);

#endif
