/***********************************************************************
**
**   radiopoint.h
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#ifndef RADIOPOINT_H
#define RADIOPOINT_H

#include <singlepoint.h>

/**
  * This class provides a mapelement for radio-navigation-facilities. It is
  * derived from SinglePoint. This class is used for: VOR, VORDME, VORTAC
  * and NDB.
  *
  * @see BaseMapElement#objectType
  *
  * @author Heiner Lamprecht, Florian Ehinger
  * @version 0.1
  */

class RadioPoint : public SinglePoint
{
 public:
  /**
    * Creates a new radio-point. n is the name of the element, t is the typeID,
	  * latPos and lonPos give the position of the element, f is the frequency and
	  * a is the alias.
    */
  RadioPoint(QString n, unsigned int t, long latPos,
              long lonPos, QString f = 0, QString a = 0);
  /** */
  ~RadioPoint();
  /**
    * Draws the element into the given painter.
    */
  virtual void drawMapElement(QPainter* targetPainter,
        double dX, double dY, long mapCenterLon);
  /**
    * Virtual function for writing the element-data into the given
    * binary-map-file.
    */
  virtual bool writeElementBin(const char* fileName);
  /**
    * Virtual function for writing the element-data into the given
    * ascii-map-file.
    */
  virtual bool writeElementAscii(const char* fileName);

 private:
  /** The frequency */
  QString frequency;
  /** The alias */
  QString alias;
};

#endif
