/***********************************************************************
**
**   singlepoint.cpp
**
**   This file is part of KFLog
**
************************************************************************
**
**   Copyright (c):  2000 by Heiner Lamprecht, Florian Ehinger
**
**
**   This program is free software; you can redistribute it and/or
**   modify it under the terms of the GNU General Public License as
**   published by the Free Software Foundation; either version 2 of
**   the License, or (at your option) any later version.
**
**   This program is distributed in the hope that it will be useful,
**   but WITHOUT ANY WARRANTY; without even the implied warranty of
**   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
**   GNU General Public License for more details.
**
**   You should have received a copy of the GNU General Public
**   License along with this program; if not, write to the Free
**   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
***********************************************************************/

#include "singlepoint.h"

#include <mapcalc.h>

#include <kapp.h>
#include <kiconloader.h>
#include <qdatastream.h>
#include <qfile.h>
#include <qtextstream.h>

bool SinglePoint::writeElementBin(const char* fileName)
{
  QFile outputFile(fileName);
  if(!outputFile.open(IO_WriteOnly | IO_Append)) {
    return false;
  }
  QDataStream out(&outputFile);

  out << (Q_UINT8) typeID;
  // Bei welchen Elementen mu der Name mit abgespeichert werden???
  if((typeID != BaseMapElement::RoadBridge) &&
     (typeID != BaseMapElement::RoadTunnel) &&
     (typeID != BaseMapElement::RailwayBridge)) {
    out << (const char*) name;
  }
  out << (Q_INT32) latitude;
  out << (Q_INT32) longitude;
  out << (Q_UINT8) isWaypoint;

  outputFile.close();

  return true;
}

bool SinglePoint::writeElementAscii(const char* fileName)
{
  QFile mapFile(fileName);
  if(!mapFile.open(IO_ReadWrite)) {
    return false;
  }
  mapFile.at(mapFile.size());
  QTextStream mapOut(&mapFile);

  mapOut << "[NEW]\n"
         << "TYPE=" << typeID << endl
         << "NAME=" << name << endl
         << "AT=" << latitude << " " << longitude << endl
         << "WAYPOINT=" << (unsigned int) isWaypoint << endl
         << "[END]\n";
  mapFile.close();

  return true;
}

void SinglePoint::drawMapElement(QPainter* targetPainter,
          double dX, double dY, long mapCenterLon)
{
  extern double _scale[];
  extern double _currentScale;
  double lat, lon, projX, projY, drawX, drawY;

  lat = numToRad(latitude);
  lon = numToRad(longitude - mapCenterLon);

  projX = calc_X_Lambert(lat,lon);
  projY = calc_Y_Lambert(lat,lon);

  drawX = projX * RADIUS / _currentScale + dX;
  drawY = projY * RADIUS / _currentScale + dY;

  // ACHTUNG: Alle Icons mssen die gleiche Gre bekommen!
//  QPixmap* pixmap;

  targetPainter->setPen(QPen(QColor(0,0,0), 2));
  char* kflog_dir = "/kflog/map";
  if(_currentScale > _scale[3]) {
    kflog_dir = "/kflog/map/small";
  }

  QString tempText;
  switch (typeID) {
    case ClosedAirfield:
      break;
    case UltraLight:
      break;
    case HangGlider:
      break;
    case Parachute:
      break;
    case Ballon:
      break;
    case Village:
      targetPainter->setBrush(NoBrush);
      targetPainter->drawEllipse(drawX - 5, drawY - 5, 10, 10);
      break;
    case Oiltank:
      break;
    case Factory:
      break;
    case Castle:
      break;
    case Church:
      break;
    case Tower:
      break;
    case HighwayEntry:
      break;
    case RailwayBridge:
      break;
    case Station:
      break;
    case Dam:
      targetPainter->setBrush(QBrush(QColor(0,0,0),SolidPattern));
      targetPainter->setPen(QPen(QColor(0,0,0), 1));
      break;
    case Lock:
      targetPainter->setBrush(NoBrush);
      targetPainter->setPen(QPen(QColor(0,0,0), 1));
      break;
  }
}

void SinglePoint::setWaypoint(bool isW)
{
  isWaypoint = isW;
}

bool SinglePoint::isWayPoint()
{
  return isWaypoint;
}

struct point SinglePoint::getPosition()
{
  struct point pos;
  pos.latitude = latitude;
  pos.longitude = longitude;

  return pos;
}

SinglePoint::SinglePoint(QString n, unsigned int t,
          long latPos = 0, long lonPos = 0, bool isW = false)
{
  name = n;
  latitude = latPos;
  longitude = lonPos;
  typeID = t;
  isWaypoint = isW;
}

SinglePoint::~SinglePoint()
{

}
