#ifndef KGPSWIDGET_H 
#define KGPSWIDGET_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <qwidget.h>

#include <qtoolbutton.h>
#include <qradiobutton.h>
#include <qdialog.h>

#include <ksky.h>
#include <kbar.h>

class KGPSWidget : public QWidget
{
	Q_OBJECT
public:
	KGPSWidget(QWidget *parent = 0, const char *name = 0);
	virtual ~KGPSWidget();
	
	void timerEvent(QTimerEvent*);
	
	void open();
	int open_serialport(int, int);
	int close_serialport(int);
	void close();
	
	KSky* sky;
	KBar* bar;
	KToolBar* toolbar;
	
	QToolButton* toolbutton;

public slots:
	void properties();
};

class KPropertiesDlg : public QDialog
{
	Q_OBJECT
public:
	KPropertiesDlg(QWidget *parent = 0, const char *name = 0);
	
	QRadioButton* baud4800button;
	QRadioButton* baud9600button;
	QRadioButton* garminbutton;
	QRadioButton* rockwellbutton;
	QRadioButton* com1button;
	QRadioButton* com2button;
	QRadioButton* com3button;
	QRadioButton* com4button;

public slots:
	void baudrate(int );
	void gpsreceiver(int );
	void comport(int );
};

#endif // KGPSWIDGET_H 
