#include <ksky.h>
#include <ksky.moc>

#include <qlayout.h>
#include <qpainter.h>

#include <gps_parse.h>

#include <xpm/red_sat.xpm>
#include <xpm/gray_sat.xpm>

KSky::KSky(QWidget *parent, const char *name)
	: QWidget(parent, name)
{
}

KSky::~KSky()
{
}

#define PI	3.141592654

void drawSat(QPainter* paint, int w, int h, int az, int el, int satnr, const char** xpm)
{
	char nrstr[5];
	int r;
	double x,y;

	QFont f("Times", 14, QFont::Bold);

	w > h ? r = (h-20)/2 : r = (w-20)/2;	
	
	x = (r+10)+ r * (90.-el)/90. * sin(az*2.*PI/360.);
	y = (r+10)- r * (90.-el)/90. * cos(az*2.*PI/360.);

	paint->drawPixmap(x - 8, y - 8, QPixmap(xpm));
	sprintf(nrstr, "%d", satnr);
	paint->setFont(f);
	paint->drawText(x + 4, y, nrstr);
}

void drawCircle(QPainter* paint, int w, int h)
{
	int r;

	w > h ? r = h-20 : r = w-20;	
	paint->eraseRect(0,0, w, h);
	paint->drawArc(10,10,r,r, 0, 360 * 16);
	paint->drawArc(10 + r/4,10 + r/4,r/2,r/2, 0, 360 * 16);
	paint->drawPoint(10 + r/2,10 + r/2);
}

extern GSVData gsvData;

void KSky::paintEvent(QPaintEvent*)
{
	updateDisplay();
}

void KSky::resizeEvent(QResizeEvent* resizeEv)
{
	updateDisplay();
}

void KSky::updateDisplay()
{
	int i;
	QPixmap pix(size());
	QPainter tmp;
	tmp.begin(&pix);
	drawCircle(&tmp, width(), height());
	for(i = 0; i < gsvData.num_sats; i++)
	{
		if(gsvData.sat[i].prn == 0) continue;
		(gsvData.sat[i].snr != 0) ? 
			drawSat(&tmp, width(), height(), gsvData.sat[i].az,gsvData.sat[i].elev, gsvData.sat[i].prn, red_sat_xpm)
			: drawSat(&tmp, width(), height(), gsvData.sat[i].az,gsvData.sat[i].elev, gsvData.sat[i].prn, gray_sat_xpm);
	}
	tmp.end();
	QPainter paint(this);
	paint.drawPixmap(0,0,pix);
}
