/**
* @short Our extended KEdit class.
*
* Derived instance of KEdit - this was mainly done as I could find no
* public member function of KEdit or QMultiLineEdit which would allow me
* to simply select a line - I wanted access to the protected member
* end() of QMultiLineEdit.  In addition, this could be handy for future
* enhancements to the KEdit class for KGrep.
*              7-Sept-99 Jeff Cody (jcody@logikos.com)
*
* @author Keith Brown <kbrown@logikos.com>, Jeff Cody <jcody@logikos.com>
* @version 0.0.1
**/

////////////////////////////////////////////////////////////////////////
//
//  Originated by Logikos, Inc.  http://www.logikos.com
//
//  Class Name  : KGrepEdit
//
//  File Name   : kgrepedit.h
//
//  Originated  : 7-Sept-99  Keith Brown (kbrown@logikos.com),
//                           Jeff Cody   (jcody@logikos.com)
//
//  Abstract    : Extended KEdit widget.  See notes above.
//
//  Compiler    : egcs-1.1.2, qt 1.44, KDE 1.1.1
//
//  Revisions   :
//
////////////////////////////////////////////////////////////////////////
#ifndef KGREPEDIT_H
#define KGREPEDIT_H

// Compiler includes
#include <kapp.h>
#include <keditcl.h>

// Project includes

// Types and constants

// Forward declarations



class KGrepEdit : public KEdit
{
    // Meta-object compiler thingy
    Q_OBJECT

    // Methods
    public:
        /** Constructor. */
        KGrepEdit(KApplication* app=0, QWidget* parent=0, const char* name=0, const char* filename=0)
            : KEdit(app, parent, name, filename) {}

        /** Highlights the line with the cursor on it. */
        void highlightResult();

        /** Unhighlights the line with the cursor on it. */
        void unHighlightResult();

};  // end class KGrepEdit


// Inline function definitions
////////////////////////////////////////////////////////////////////////
//
//  Function      : highlightResult
//
//  Originated    : 7-Sept-99
//
//  Abstract      : Select the text on the line on which the cursor
//                  is at.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
inline void KGrepEdit::highlightResult()
{
    // BEGIN
    end(true);

    return;

}   // end KGrepEdit::highlightResult()


////////////////////////////////////////////////////////////////////////
//
//  Function      : unHighlightResult
//
//  Originated    : 29-Sept-99
//
//  Abstract      : Unselect the text on the line on which the cursor
//                  is at.
//
//  Parameters    : none
//
//  Return Value  : none
//
//  Exceptions    : none
//
//  Revisions     : none
//
////////////////////////////////////////////////////////////////////////
inline void KGrepEdit::unHighlightResult()
{
    // BEGIN
    home(false);

    return;

}   // end KGrepEdit::unHighlightResult()



#endif // KGREPEDIT_H
