/*
 * heisedlg.h
 *
 * Copyright (c) 1998 Michael Kropfberger <mkropfbe@edu.uni-klu.ac.at>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef _HEISEDLG_H
#define _HEISEDLG_H


#include <qapp.h>
#include <qpushbt.h>
#include <qscrbar.h>
#include <qlcdnum.h>
#include <qfont.h>
#include <qlayout.h>
#include <qmlined.h>
#include <qgrpbox.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qcombo.h>


#include "heisewrapper.h"
#include "klistedit.h"

class HeiseDlg : public QWidget {
    Q_OBJECT

 public:
    HeiseDlg(QWidget *parent=0,const char *name=0);
   QSize sizeHint();

 protected:
   void resizeEvent(QResizeEvent *); 

 signals:
  // these signals are just emitted, but the according slots are NOT
  // called! this has to be done from the signal-receiving application
  // above (this enables me to turn off all buttons in KTopLevelWidget )
   void startSearch();
   void stopSearch();
   void searchDone();
 
 public slots:
   void updateDBSlot(QString file);
   void startSearchSlot();
   void stopSearchSlot();
   void searchDoneSlot();

 private slots:
  void conjModeSlot(int mode)
   { debug("conjMode %d",mode);
hw->setPatternConjunctionMode( 
       (HeiseWrapper::PatternConjunctionMode)(mode) ); };

  void elimDuplicatesSlot(int mode)
    { hw->setElimDuplicatesMode( (mode==1) ); };

  void phonSearchSlot(int mode) 
      { hw->setPhoneticSearchMode( (mode==1) ); };
  
  void ignoreCaseSlot(int mode)
    { hw->setIgnoreCaseMode( (HeiseWrapper::Mode)(mode) ); };

  void regExprSlot(int mode)
    { hw->setRegExprMode( (HeiseWrapper::Mode)(mode) ); };

  void umlautConvSlot(int mode)
    { hw->setUmlautConversionMode( (HeiseWrapper::Mode)(mode) ); };

 
 private:
  QString        *heisereg_path;
  QString        *heisereg_proggy;
  QString        *heisereg_frm;
  bool           conjunctPatternsByAND;

  HeiseWrapper   *hw;
  QVBoxLayout    *mainLayout;
  QGroupBox      *patternGroup;
    KStrListEdit   *patternEdit;
    QButtonGroup   *searchGroup;
    QPushButton    *startBtn, *stopBtn;
  QGroupBox      *paramGroup;
    QButtonGroup   *onOffGroup[2];
       QRadioButton   *on_OnOffRadio[2]
                     ,*off_OnOffRadio[2];
    QButtonGroup   *modeGroup[3];
       QRadioButton   *on_ModeRadio[3]
                     ,*off_ModeRadio[3]
                     ,*auto_ModeRadio[3];
  QGroupBox      *hwGroup;

};

#endif  /* ifdef _HEISEDLG_H */
