/*
 * heisewrapper.cpp
 *
 * Copyright (c) 1998 Michael Kropfberger <mkropfbe@edu.uni-klu.ac.at>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <qstring.h>
#include <qfileinf.h>

#include <kapp.h>
#include "klocale.h"

#include "heisewrapper.h"
#include "heisewrapper.moc"


/************************************************************************
* Constructor
*/
HeiseWrapper::HeiseWrapper(QWidget *parent,const char* name)
                                  : QWidget(parent,name) 
{
  // default values
//  heisereg_path = new QString("./heisereg");
  QString s = kapp->kde_datadir();
  heisereg_path = new QString();
  heisereg_path->sprintf("%s/kheise/heisereg",s.data() );
  //  debug("heisereg_path: %s",heisereg_path->data() );
  heisereg_proggy = new QString(heisereg_path->copy());
  heisereg_proggy->append("/regpl211");
  heisereg_frm = new QString(heisereg_path->copy());
  heisereg_frm->append("/inhalt.frm");
 
  QFileInfo *dbFile = new QFileInfo(heisereg_frm->data());
  if ( !dbFile->exists() )
    fatal(klocale->translate("ERROR: [%s] does not exist!")
                             ,heisereg_frm->data() );

  conjunctPatternsByAND=TRUE;
  backEndKilled=FALSE;
  nrOfReceivedStdErrOut=0;

  phoneticSearch=FALSE;
  elimDuplicates=FALSE;

  ignoreCase=AUTO;
  regExpr=AUTO;
  umlautConversion=AUTO;


  backEndProc = new KProcess;
  QObject::connect( backEndProc, SIGNAL( processExited( KProcess* ) ),
                                        this, SLOT( searchDoneSlot() ) );
  connect( backEndProc, SIGNAL(receivedStdout(KProcess *, char *, int) ),
           this, SLOT (receivedStdErrOutSlot(KProcess *, char *, int)) );
  connect( backEndProc, SIGNAL(receivedStderr(KProcess *, char *, int) ),
           this, SLOT (receivedStdErrOutSlot(KProcess *, char *, int)) );


  outputMLE = new QMultiLineEdit(this);
  outputMLE->setReadOnly(TRUE);
  outputMLE->setOverwriteMode(TRUE);
  show();

}

/************************************************************************
  * updateDB
**/
void HeiseWrapper::updateDB(QString file) {
  //debug("HeiseWrapper::updateDB");
 if ( (file.isEmpty()) || (backEndProc->isRunning()) ) return;
   
  outputMLE->setCursor(waitCursor);
  outputMLE->clear();
  backEndProc->clearArguments();
  backEndKilled=FALSE;
  nrOfReceivedStdErrOut=0;

  (*backEndProc) << heisereg_proggy->copy()
                 << "-f" << heisereg_frm->copy()
                 << "-u" << file.copy();

  if (!backEndProc->start( KProcess::NotifyOnExit, KProcess::AllOutput ))
    fatal("could not execute KProcess");
}


/************************************************************************
  * startSearch
**/
void HeiseWrapper::startSearch(QStrList *patterns) {
  //debug("HeiseWrapper::startSearch");
  if (backEndProc->isRunning()) return;
  outputMLE->setCursor(waitCursor);
  outputMLE->clear();
  backEndProc->clearArguments();
  backEndKilled=FALSE;
  nrOfReceivedStdErrOut=0;

  (*backEndProc) << heisereg_proggy->copy()
                 << "-f" << heisereg_frm->copy()
                 << "-phon" << ((phoneticSearch==TRUE)?"on":"off")
                 << "-dup" << ((elimDuplicates==TRUE)?"on":"off");
  
  if (ignoreCase!=AUTO) {
      (*backEndProc) << "-ign" << ((ignoreCase==ON)?"on":"off");
  }

  if (regExpr!=AUTO) {
      (*backEndProc) << "-re" << ((regExpr==ON)?"on":"off");
  }

  if (umlautConversion!=AUTO) {
      (*backEndProc) << "-iso" << ((umlautConversion==ON)?"on":"off");
  }
  
  if (patternConjunctionMode()==AND) {
     for (QString s=patterns->first(); s != 0; s=patterns->next()) { 
                 //debug("AND pattern: %s",s.data());
                 (*backEndProc) << s;
     }
  } else {
     QString erg;
     QString s=patterns->first();
     //debug("OR pattern: %s",s.data());
     erg.append(s);
     for (s=patterns->next(); s != 0; s=patterns->next()) { 
                 //debug("OR pattern: %s",s.data());
                 erg.append("|");
                 erg.append(s);
     } 
     (*backEndProc) << erg;
  }


  if (!backEndProc->start( KProcess::NotifyOnExit, KProcess::AllOutput ))
    fatal("could not execute KProcess");
}

/************************************************************************
  * stopSearch
**/
void HeiseWrapper::stopSearch() {
  //debug("HeiseWrapper::stopSearch");
  if (!backEndProc->isRunning()) return;
  outputMLE->setCursor(arrowCursor);
  backEndProc->kill();
  backEndKilled=TRUE;
  nrOfReceivedStdErrOut=0;
}

/************************************************************************
  * searchDoneSlot
**/
void HeiseWrapper::searchDoneSlot() {
  //debug("HeiseWrapper::searchDoneSlot normalExit: %d   exitStatus: %d "
  //        ,backEndProc->normalExit()
  //        ,backEndProc->exitStatus() );
 
  kapp->restoreOverrideCursor();
  outputMLE->setCursor(arrowCursor);
  emit searchDone();
  backEndKilled=FALSE;
  nrOfReceivedStdErrOut=0;
 
};

/************************************************************************
  * DB_isWritable checks if the calling user is allowed to update the DB
**/
bool HeiseWrapper:: DB_isWritable() {
  //debug("HeiseWrapper:: DB_isWritable");
  QFileInfo *dbFile = new QFileInfo(heisereg_frm->data());
  CHECK_PTR(dbFile);
  return dbFile->isWritable();
};

/************************************************************************
  * resizeEvent
**/
void HeiseWrapper::resizeEvent(QResizeEvent *) {
//debug("HeiseWrapper::resizeEvent");
  outputMLE->setGeometry(0,0,width(),height());
};

/************************************************************************
  * receivedStdoutSlot
**/
void HeiseWrapper::receivedStdErrOutSlot(KProcess *, char *data, int len) {
  //debug("HeiseWrapper::receivedStdErrOutSlot");
  if (backEndKilled) return;  // to stop immediately
  nrOfReceivedStdErrOut++;
  QString s;
  s = data;
  if  ( nrOfReceivedStdErrOut== 1 ) {  // first part
     int pos = s.find("--------------------------------------------------------");
     if (pos >= 0) s = s.mid(pos, len-pos); // cuts the initial pref-states
  } else  
     s = s.left(len);

  s = outputMLE->text()+ s;  // add to old contents without a return
  outputMLE->setText(s);
};


