#ifndef KCMHOTKEYS_H 
#define KCMHOTKEYS_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kcontrol.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qcheckbox.h>
//#include <kglobalaccel.h>
#include <qvalidator.h>
#include <qcombobox.h>
#include "win_dialog.h"

const int NAME_COL_WIDTH = 170;
const int HOTKEY_COL_WIDTH = 170;

class KCMHotKeysApp
    : public KControlApplication
    {
    Q_OBJECT
    public:
	KCMHotKeysApp(int &argc, char **argv, const QString& );
	virtual ~KCMHotKeysApp();
	virtual void init();
	virtual void apply();
	virtual void defaultValues();
	void prepare();
	virtual bool x11EventFilter( XEvent * );
    private:
        enum run_type_t { run, url, macro } run_type;  // what kind of action
        enum w_par_t { not_sig, if_ex, if_exp };
	enum search_win_t { any, created, last };
	struct KHotData // this one is not equal to KHotKeysApp::KHotData
            {
            run_type_t run_type;
            QString	run_command;	// command to execute
            w_par_t	use_command;	// use WM_COMMAND to find instance
            QString	command;	// use this WM_COMMAND value
            w_par_t	use_title;	// use WM_NAME or ( CHECKME ?? KWM_WIN_TITLE )
            QString	wtitle;		// value
            w_par_t	use_class;	// use WM_CLASS
            QString	wclass;		// value
	    search_win_t    win_search;
	    uint	keycode;	// hotkey keycode associated
	    };
	void readSettings();
	void writeSettings();
        const char* w_par_t_to_str( w_par_t type );
	w_par_t str_to_w_par_t( const QString& str );
	QDict< KHotData > hotkeys_data;
	friend class KHKWidget;
	KHKWidget* widget;
	QWidget* kwm_module;
	win_dialog* wins;
	bool processing_windows;  // for kwm_module
//	KGlobalAccel* kga;  // CHECKME no need to use KHKGlobalAccel ...
	long one_act_timeout;
	int name_col_width;
	int hotkey_col_width;
	uint reset_keycode;             // for "Reset status"
	int main_win_width, main_win_height;
	int macro_win_width, macro_win_height;
	int detect_win_width, detect_win_height;
    };
    
typedef KCMHotKeysApp dt;
    	
class KHKWidget
    : public QWidget
    {
    Q_OBJECT
    public:
        KHKWidget( QWidget* parent );
        virtual ~KHKWidget();
	long get_exec_timeout() const;
	int get_name_col_width() const;
	int get_hotkey_col_width() const;
	void flush();
	void reload();
	void prepare_data();
	void after_data();
    protected slots:
	void action_runcommand_browse();
	void action_class_toggle(int);
	void got_highlight(QListViewItem*);
	void fix_highlight();
	void action_title_toggle(int);
	void action_name_changed(const char*);
	void action_command_toggle(int);
        void action_hotkey_change();
    	void new_action();
	void delete_action();
	void copy_action();
	void reset_button_change();
	void guess_pressed();
	void action_usecommand_changed(int status);
    protected:
	void change_hotkey( bool reset_key_P );
	void set_enable_empty( bool );
	void save_action_data();
	void load_action_data( const char* action );
	bool may_change_pos();
	bool macro_check( const QString& );
	QListView* actions_list;
	QLineEdit* action_name;
	QLineEdit* action_runcommand;
	QLineEdit* action_command;
	QLineEdit* action_title;
	QLineEdit* action_class;
	QComboBox* combo_win_search;
	QPushButton* button_hotkey;
	QPushButton* button_browse;
	QLineEdit* execute_timeout;
	QPushButton* copy_button;
	QPushButton* delete_button;
	QLineEdit* action_hotkey_text;
        QComboBox* combo_runcommand;
    	QComboBox* combo_action_class;
	QComboBox* combo_action_title;
	QComboBox* combo_action_command;
	QPushButton* button_reset_status;
	QPushButton* button_guess;
	QLineEdit* reset_hotkey_text;
	QListViewItem* last_index;
	bool ignore;      // for got_highlight()
    };


class QHKValidator:
    public QValidator
    {
    Q_OBJECT
    public:
        QHKValidator( QWidget * parent, const char* name = 0 );
        virtual State validate( QString &, int & );
    };

// Inline

inline
long KHKWidget::get_exec_timeout() const
    {
    return QString( execute_timeout->text() ).toLong();
    }

inline
void KHKWidget::flush()
    {
    actions_list->clear();
    last_index = NULL;
    }

inline
void KHKWidget::prepare_data()
    {
    if( actions_list->currentItem() >= 0 )
	save_action_data();
    }

inline
int KHKWidget::get_name_col_width() const
    {
    return actions_list->columnWidth( 0 );
    }

inline
int KHKWidget::get_hotkey_col_width() const
    {
    return actions_list->columnWidth( 1 );
    }

inline
void KCMHotKeysApp::prepare()
    {
    readSettings();
    }

inline
QHKValidator::QHKValidator( QWidget * parent, const char* name )
    : QValidator( parent, name )
    {
    }

#endif // KCMHOTKEYS_H
