#ifndef KHOTKEYS_H 
#define KHOTKEYS_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kwmmapp.h>
#include <khkglobalaccel.h>
#include <qtimer.h>

/**
 *
 * @short App class
 * @author Lubos Lunak <l.lunak@email.cz>
 * @version 0.1
 */
 
class KHotKeysApp
    : public KWMModuleApplication
    {
    Q_OBJECT
    public:
	KHotKeysApp( int&, char** );
    	virtual	~KHotKeysApp();
	virtual bool x11EventFilter( XEvent * );
	bool run_it() const;
    protected:
	QString get_window_command( Window );
	QString get_window_title( Window );
	QString get_window_class( Window );
	void readSettings();
	bool check_unique();
	bool query_unique( Window, Atom );
	KHKGlobalAccel* kga;
    protected slots:
	void got_hotkey( const char*, const QString&, uint );
	void window_add( Window );
	void window_remove( Window );
	void window_active( Window );
	void reset_status();
	void command_received( QString );
    protected:
        enum run_type_t { run, url, macro } run_type;  // what kind of action
        enum w_par_t { not_sig, if_ex, if_exp };
	enum search_win_t { any, created, last };
	struct KHotData
            {
	    run_type_t	run_type;
            QString	run_command;	// command to execute or macro
            w_par_t	use_command;	// use WM_COMMAND to find instance
            QString	command;	// use this WM_COMMAND value
            w_par_t	use_title;	// use WM_NAME or ( CHECKME ?? KWM_WIN_TITLE )
            QString	wtitle;		// value
            w_par_t	use_class;	// use WM_CLASS
            QString	wclass;		// value
            bool	is_act_window;    // don't change act_window twice
            Window	act_window;	// window to switch to
	    Window	top_parent;	// parent ( for last active windows )
	    search_win_t    win_search;
            QTimer	one_act_timer;  // waiting for window creation
            };
        void run_app( KHotData* );
        const char* w_par_t_to_str( w_par_t type );
	w_par_t str_to_w_par_t( const QString& str );
	bool is_w_par_t_match( const QString&, const QString&, w_par_t );
	void run_macro( KHotData* );
        bool window_match( KHotData* data, Window w );
	void send_macro_key( uint keycode );
        QDict< KHotData > hotkeys_data;
        long one_act_timeout;
	QList< Window > windows_active; // windows in the order they were last activated
	QWidget* unique_win;              // for unique check
    };


inline
bool KHotKeysApp::run_it() const
    {
    return unique_win != NULL;
    }
    

#endif // KHOTKEYS_H 
