//////////////////////////////////////////////////////////////////////////////
// This software is distributed under the terms of the General Public License.
//
// Program : kless
// Author  : Norbert Drees & Ralf Haferkamp
// E-Mail  : norbert@et-inf.fho-emden.de
//           hafer@et-inf.fho-emden.de
//////////////////////////////////////////////////////////////////////////////

#include "main.h"
#include <termio.h>
#include <sys/ioctl.h>

QList<KLessWindow> KLessWindow::windowList;

KApplication	*app;

QString			ConfigEditor;
QString			ConfigPrinter;
QString			ConfigWidth;
QString			ConfigHeight;
QString			ConfigFont;
QString			ConfigTab;

int main( int argc, char **argv ) {

	struct termio savetty;
	app = new KApplication ( argc, argv, "kless" );
	
	// Read configuration
	KConfig *conf = app->getConfig();
	conf->setGroup( "Options" );
	ConfigEditor = conf->readEntry( "Editor", NULL );
	ConfigPrinter = conf->readEntry( "Printer", NULL );
	ConfigTab = conf->readEntry( "Tab", NULL );
	conf->setGroup( "Window" );
	ConfigWidth = conf->readEntry( "WinWidth", NULL );
	ConfigHeight = conf->readEntry( "WinHeight", NULL );
		
	KLessWindow *lw = new KLessWindow();
	KLessWindow::windowList.append( lw );
		
	lw->show();

   if( argc > 1 ) {
		lw->argLoad( argv[1] );
	} else {
		// is there input from pipe ?
		if( ioctl( 0, TCGETA, &savetty ) == -1 ) {
			lw->readSTDIN();
		}
	} 

	return app->exec();
}
