/*
 *            klm: A lm_sensors front end for the KDE project
 *
 * $Id: UpDownButton.cpp,v 1.6 1999/01/09 18:55:58 humphrey Exp $
 *
 *            Copyright (C) 1998 Brendon Humphrey
 *                   brendy@swipnet.se
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "UpDownButton.h"

#include <qpixmap.h>
#include <qlayout.h>
#include <kbutton.h>
#include <kapp.h>
#include <kiconloader.h>


UpDownButton::UpDownButton( 
  QWidget *parent = NULL, 
  const char *name = NULL ) : QFrame( parent, name )
{
  KIconLoader *il = kapp->getIconLoader();
  
  up = new KButton( this, "up" );
  up->setPixmap( il->loadIcon( "up.xpm" ) );
  up->setAutoRepeat( true );
  
  down = new KButton( this, "down" );
  down->setPixmap( il->loadIcon( "down.xpm" ) );
  down->setAutoRepeat( true );
  
  connect(
    up, SIGNAL(clicked()),
    this, SLOT(upButtonClicked()) );
  
  connect(
    down, SIGNAL(clicked()),
    this, SLOT(downButtonClicked()) );
  
  qtarch_layout_1 = new QBoxLayout( 
      this, 
      QBoxLayout::TopToBottom, 
      2, 2, 
      NULL );
  qtarch_layout_1->addStrut( 0 );
  qtarch_layout_1->addWidget( up, 1, 36 );
  qtarch_layout_1->addWidget( down, 1, 36 );
}

UpDownButton::~UpDownButton()
{
  if (up) delete up;
  if (down) delete down;
}

void UpDownButton::upButtonClicked()
{
  emit( upClicked() );
}

void UpDownButton::downButtonClicked()
{
  emit( downClicked() );
}


#include "UpDownButton.moc.cpp"
