/****************************************************************
**
** Implementation of CPUPanel class
**
****************************************************************/

#include <assert.h>

#include <kapp.h>

#include "cpupanel.h"

extern "C" {
    #include <stdio.h>
}

const char *CPUPanel::statName = "/proc/stat";

// Constructor f. CPU Panel
CPUPanel::CPUPanel(QWidget *parent, const char *name) :
    LPanel(3,parent,name)
{
    setIncremental(true);
    setFilled(true);
    setToolTip(i18n("CPU Load (User/Nice/Sys); scale = 1.00"));
    setDescription(i18n("&CPU load"));
    setName("CPU");
    
    setYScale(1.00);              // CPU activity measured in range 0..1
    
    setGraphColor(0,QColor(blue));     // User
    setGraphColor(1,QColor(green));    // Nice
    setGraphColor(2,QColor(red));      // Sys
    
    setBackgroundColor(QColor(darkGray));
    
    (void) getNewData(0);
    // Start timer 
    // startTimer(getRedrawInterval());
}


// Destructor f. CPU Panel
CPUPanel::~CPUPanel()
{
}


// read another Line from virtual CPU Statistics file
// "cpu  2803260 607720 8126308 187210190"
bool CPUPanel::getNewData(FArray *row) 
{
    char line[255]; // Should be enough
    FILE *inpfile;
    unsigned long jUser, jNice, jSys, jIdle;
    static unsigned long oldjUser = 0,oldjNice = 0, oldjSys = 0, oldjIdle = 0,
                         oldjSum  = 0;
    
    inpfile = fopen(statName,"r");
    if (!inpfile) {
        cerr << "CPUPanel::CPUPanel: Could not open file " << statName << endl;
        exit(-1);
    }
    fgets(line,sizeof(line),inpfile);
    fclose(inpfile);
    
    // Simply parse CPU information
    if ( strncmp(line,"cpu",3) || 
        (4 != sscanf(line + 4,"%lu %lu %lu %lu",&jUser,&jNice,&jSys,&jIdle)) ) {
        cerr << "Unparseable CPU information in " << line;
        return false;
    }
    unsigned long jSum = jUser + jNice + jSys + jIdle;
    bool retval; // true if row is to be appended, false if initial call

    // Compute derivatives
    if (oldjSum != 0) {
        assert(row);
        
        double deltaJiffies = 1.0 / (jSum - oldjSum);
        (*row)[0] = (jUser - oldjUser) * deltaJiffies;
        (*row)[1] = (jNice - oldjNice) * deltaJiffies;
        (*row)[2] = (jSys  - oldjSys)  * deltaJiffies;
        
        retval = true;
    }
    else {
        retval = false;
    }
    
    oldjUser = jUser;
    oldjNice = jNice;
    oldjSys  = jSys;
    oldjIdle = jIdle;
    oldjSum  = jSum;
    
    return retval;    

}
