/****************************************************************
**
** Implementation of LoadPanel class
**
****************************************************************/

#include <assert.h>
#include <kapp.h>

#include "loadpanel.h"

extern "C" {
    #include <stdio.h>
}

const char *LoadPanel::statName = "/proc/loadavg";

// Constructor f. Load Avg. Panel
LoadPanel::LoadPanel(QWidget *parent, const char *name) :
    LPanel(1,parent,name)
{
    setIncremental(false);
    //setFilled(true);
    
    setYScale(1.00); // Initially, but will be overridden with next redraw event
    setYLines(1.0);  // Denote dynamic Scaling
    setGraphColor(0,QColor(blue));
    setScaleColor(QColor(black));
    setBackgroundColor(QColor(darkGray));
    setLowWM(0);
    setHighWM(0);
    setLowBoundCmd("");
    setHighBoundCmd("");
    setToolTip(i18n("Load Average (dynamic scaling)"));
    setDescription(i18n("&Load Avg. Panel"));
    setName("Load Avg.");
    // Start timer 
    // startTimer(getRedrawInterval());
}



// Destructor f. CPU Panel
LoadPanel::~LoadPanel()
{
}


// read another Line from virtual LoadStatistics file
// 0.09 0.14 0.16 2/79 1166 
bool LoadPanel::getNewData(FArray *row) 
{
    char line[255]; // Should be enough
    FILE *inpfile;

    inpfile = fopen(statName,"r");
    if (!inpfile) {
        cerr << "LoadPanel::LoadPanel: Could not open file " << statName << endl;
        exit(-1);
    }
    fgets(line,sizeof(line),inpfile);
    fclose(inpfile);
    
    assert(row);
    // Simply parse CPU information
    if ( 1 != sscanf(line,"%f",&((*row)[0])) ) {
        cerr << "Unparseable load information in " << line;
        return false;
    }

    return true;    
}
