/****************************************************************
**
** Definitions for Options dialog
**
****************************************************************/

//
// $Id: optdialog.h,v 1.4 1998/10/27 22:04:13 pi Exp pi $
//
// $Log: optdialog.h,v $
// Revision 1.4  1998/10/27 22:04:13  pi
// Bug Fixes for V 0.61
//
// Revision 1.3  1998/10/23 11:59:08  pi
// Checkin for V 0.6
//
// Revision 1.2  1998/10/04 15:57:56  pi
// After first version of Options dialog
//
// Revision 1.1  1998/08/23 19:55:51  pi
// Initial revision
//
//

#ifndef __OPTDIALOGH__
#define __OPTDIALOGH__

#include <qstring.h>
//#include <qdialog.h>
#include <qtabdlg.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <kapp.h>


const int A_VERT   =  0;
const int A_HORIZ  =  1;

const int maxPanels = 6; // FIXME!!

// This is a struct for all options to be passed to and from 
// the dialog
typedef struct optionSet
{
    // General Options
    int redrawInterval;
    int alignment;
    int nPanels;
        
    // Panel options
    QString label[maxPanels];
    
    bool panelVis[maxPanels];
    
    QString dblClckAction[maxPanels];

    QString lowAction[maxPanels],     
            highAction[maxPanels];
    float   lowWM[maxPanels],
            highWM[maxPanels];
} OptionSet;


class OptDialog : public QTabDialog
{
    Q_OBJECT

public:

    OptDialog(OptionSet os, QWidget *parent = 0, const char *name=0);   
    void set(OptionSet);
    
public:
                            
private:
//     static const WIDTH      = 350;
//     static const HEIGHT     = 250;
//     static const BTN_WIDTH  =  60;
//     static const BTN_HEIGHT =  30;

    int np; // Number of Panels
    
    QSpinBox *redrawInterval;
    
    QRadioButton *alignment[2];
    
    QCheckBox *panelVis[maxPanels];
    
    QLineEdit *dblClckAction[maxPanels];
    
    QLineEdit *lowAction[maxPanels],
              *highAction[maxPanels];
    QLineEdit *lowWM[maxPanels],
              *highWM[maxPanels];    
        
private slots:
    void doApply();
    
signals:
    void applyOptions(OptionSet);

};

#endif
