#include "klookupwidget.h"
#include "kldap.h"
#include <kmsgbox.h>

KLookupWidget::KLookupWidget(QWidget *parent, const char *name, KTMainWindow *m)
	: QWidget(parent, name), mainw(m)
{

	backEnd = new KLdap("ldap.four11.com", LDAP_PORT);

	layout = new QVBoxLayout(this);
	queryBox = new QHBoxLayout();
	addrList = new KTabListBox(this, "AddressBook", 4);  

	layout->addLayout(queryBox, 0);
	layout->addWidget(addrList, 1);

	queryText  = new KLined(this, "Query");
	connect(queryText, SIGNAL(returnPressed()), 
	        SLOT(Lookup()));

	queryLabel  = new QLabel(this, "QueryLabel");
	queryLabel->setText("Enter Name To Query:");

	queryBox->addWidget(queryLabel, 1);
	queryBox->addWidget(queryText, 3);

	queryText->setMinimumSize(queryText->sizeHint() * (float) 1.2);

	addrList->setColumn(0, i18n("Name"), 150);
	addrList->setColumn(1, i18n("Email Address"), 200);
	addrList->setColumn(2, i18n("Home Phone"), 125);
	addrList->setColumn(3, i18n("Business Phone"), 125);
	addrList->setMinimumSize(50, 50);      

	addrList->clear();
	
	show();
}

KLookupWidget::~KLookupWidget()
{
}


int 
KLookupWidget::Lookup()
{
		Entry *res;
		char sep = addrList->separator();
		int count;

		backEnd->lookup(queryText->text());
		res = backEnd->firstEntry();
		count = 1;

		addrList->clear();

		if (!res) {
			// POP up message box
			KMsgBox::message(this, "klookup: Not found", "No matching entries");
			return 0;
		}

		do {
				QString s;

				s += res->getField("Name");
				s += sep;
				s += res->getField("Email");
				s += sep;
				s += res->getField("Home Phone");
				s += sep;
				s += res->getField("Business Phone");
				s += sep;
				
				addrList->appendItem(s);
				count++;

		} while ((res = backEnd->nextEntry()));

		if (mainw) {
				QString s;
				
				s.setNum(count);
				mainw->statusBar()->changeItem(s + " items found", 0);
		}
		return 0;
}
