#ifndef ADD_EDIT_H
#define ADD_EDIT_H

#include <qdialog.h>

#include "common.h"

class QPushButton;
class QLabel;
class QLineEdit;
class QRadioButton;
class QButtonGroup;
class QComboBox;


class AddEditDialog : public QDialog {
	Q_OBJECT
public:
	AddEditDialog(QWidget *parent = 0, const char *n = 0);
	AddEditDialog(const Printer &p, QWidget *parent = 0, const char *n = 0);
	Printer printer;
public slots:
	void radioClicked();
	void serverActivated(int index);
	void validate();
protected:
	virtual void resizeEvent(QResizeEvent *event);
	void setupWindow();
protected slots:
	virtual void done(int r);
private:
	QPushButton *ok;
	QPushButton *cancel;
	QLabel *descr_label;
	QLabel *name_label;
	QLabel *server_label;
	QLineEdit *description;
	QComboBox *server_type;
	QLineEdit *name;
	QComboBox *name_combo;
	QLineEdit *host;
	QRadioButton *local;
	QRadioButton *remote;
	QButtonGroup *group;
	bool edit;
	bool have_list;
};


#endif // ADD_EDIT_H
