/*
	This file is part of `klp', a KDE Line Printer queue manager

	Copyright (C) 1998
	Frans van Dorsselaer
	<dorssel@MolPhys.LeidenUniv.nl>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

#include "lpr_local.h"
#include "server.h"
#include "inter.h"


#define i18n(s)	s


static char *printer = NULL;


char *lpr_local_set_printer(const char *h, const char *p)
{
	xfree(printer);
	if (!p)
		return NULL;
	if (h)
		return xstrdup(i18n("Remote printers not supported by this server type"));
	printer = xstrdup(p);
	return NULL;
}


int lpr_local_q_main(void)
{
	drop_root();
	execlp("lpq", "lpq", "-P", printer, (char *)0);
	perror("klp: execlp");
	return EXIT_FAILURE;
}


int lpr_local_p_main(const char * const files[])
{
	char **argv;
	int argc = 0;

	drop_root();
	argv = xmalloc(6 * sizeof(char *));
	argv[argc++] = "lpr";
	argv[argc++] = "-P";
	argv[argc++] = xstrdup(printer);
	argv[argc++] = "-U";
	argv[argc++] = xstrdup(username);
	argv[argc] = NULL;
	while (*files) {
		argv = xrealloc(argv, (argc + 2) * sizeof(char *));
		argv[argc++] = xstrdup(*(files++));
		argv[argc] = NULL;
	}
	execvp("lpr", argv);
	perror("klp: execlp");
	return EXIT_FAILURE;
}


int lpr_local_r_main(const char * const jobids[])
{
	char **argv;
	int argc = 0;

	drop_root();
	argv = xmalloc(4 * sizeof(char *));
	argv[argc++] = "lprm";
	argv[argc++] = "-P";
	argv[argc++] = xstrdup(printer);
	argv[argc] = NULL;
	while (*jobids) {
		argv = xrealloc(argv, (argc + 2) * sizeof(char *));
		argv[argc++] = xstrdup(*(jobids++));
		argv[argc] = NULL;
	}
	execvp("lprm", argv);
	perror("klp: execlp");
	return EXIT_FAILURE;
}


char **lpr_printer_list(void)
{
	char **list = NULL;
	int count = 0;

	FILE *f;
	char buf[1024];

	if (!(f = fopen("/etc/printcap", "r"))) {
		perror("klp: fopen");
		return NULL;
	}
	list = xmalloc(sizeof(char *));
	list[0] = NULL;
	while (fgets(buf, 1024, f) && *buf && (buf[strlen(buf) - 1] == '\n')) {
		if (isalpha(buf[0])) {
			buf[strcspn(buf, "|:\\")] = '\0';
			list = xrealloc(list, (count + 2) * sizeof(char *));
			list[count] = xstrdup(buf);
			list[++count] = NULL;
		}
	}
	if (fclose(f))
		perror("klp: fclose");
	return list;
}
