/*
	This file is part of `klp', a KDE Line Printer queue manager

	Copyright (C) 1998
	Frans van Dorsselaer
	<dorssel@MolPhys.LeidenUniv.nl>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <qpushbutton.h>
#include <qlistbox.h>

#include <kapp.h>

#include "select.h"
#include "add_edit.h"


SelectDialog::SelectDialog(QList <Printer> &p, int a, QWidget *parent, const char *name)
		: QDialog(parent, name, true)
		, printers(p) , active(a)
		, active_changed(false) , printers_changed(false)
{
	listbox = new QListBox(this);

	for (Printer *p2 = printers.first() ; p2 ; p2 = printers.next())
		listbox->insertItem(p2->description);
	if (!listbox->count())
		listbox->setEnabled(false);
	connect(listbox, SIGNAL(selected(int)), SLOT(accept()));
	connect(listbox, SIGNAL(highlighted(int)), SLOT(highlighted(int)));

	add = new QPushButton(i18n("Add..."), this);
	connect(add, SIGNAL(clicked()), SLOT(addPrinter()));

	edit = new QPushButton(i18n("Edit..."), this);
	connect(edit, SIGNAL(clicked()), SLOT(editPrinter()));

	remove = new QPushButton(i18n("Remove"), this);
	connect(remove, SIGNAL(clicked()), SLOT(removePrinter()));

	ok = new QPushButton(i18n("Ok"), this);
	connect(ok, SIGNAL(clicked()), SLOT(accept()));

	cancel = new QPushButton(i18n("Cancel"), this);
	connect(cancel, SIGNAL(clicked()), SLOT(reject()));

	if (active >= 0)
		listbox->setCurrentItem(active);
	highlighted(active);

	setCaption(i18n("Select printer"));
	setMinimumSize(320, 210);
}


void SelectDialog::resizeEvent(QResizeEvent *event)
{
	add->setGeometry(event->size().width() - 110, 10, 100, 30);
	edit->setGeometry(event->size().width() - 110, 50, 100, 30);
	remove->setGeometry(event->size().width() - 110, 90, 100, 30);
	ok->setGeometry(40, event->size().height() - 40, 100, 30);
	cancel->setGeometry(event->size().width() - 140, event->size().height() - 40, 100, 30);
	listbox->setGeometry(10, 10, event->size().width() - 130, event->size().height() - 60);
	int i = listbox->currentItem();
	if (i >=0 )
		if ((i < listbox->topItem()) ||
				(i >= listbox->topItem() + listbox->numItemsVisible()))
			listbox->centerCurrentItem();
}


void SelectDialog::highlighted(int i)
{
	bool b = (i >= 0);
	edit->setEnabled(b);
	remove->setEnabled(b);
	ok->setEnabled(b);
	ok->setDefault(b);
}


void SelectDialog::addPrinter()
{
	AddEditDialog ad(this);
	if (ad.exec()) {
		Printer *p = new Printer;
		*p = ad.printer;
		printers.append(p);
		listbox->setEnabled(true);
		listbox->insertItem(p->description);
		listbox->setCurrentItem(listbox->count() - 1);
		printers_changed = true;
		active_changed = true;
	}
}


void SelectDialog::editPrinter()
{
	int i = listbox->currentItem();
	AddEditDialog ed(*printers.at(i), this);
	if (ed.exec()) {
		*(printers.at(i)) = ed.printer;
		listbox->changeItem(ed.printer.description, i);
		printers_changed = true;
		active_changed = true;
	}
}


void SelectDialog::removePrinter()
{
	int i = listbox->currentItem();
	listbox->removeItem(i);
	printers.remove(i);
	if (i == active)
		active = -1;
	else if (i < active)
		active--;
	if (!listbox->count()) {
		listbox->setEnabled(false);
		highlighted(-1);
	}
	printers_changed = true;
	active_changed = true;
}


void SelectDialog::done(int r)
{
	if (r == Accepted) {
		if (listbox->currentItem() != active) {
			active = listbox->currentItem();
			active_changed = true;
		}
	}
	QDialog::done(r);
}


#include "select.moc"
