#include "mainDlg.h"
#include "mainView.h"
#include "gsSetupDlg.h"

#include <stdio.h>
#include <kapp.h> 				/* klocale is defined there */
#include <kiconloader.h>
#include <qaccel.h>


extern KApplication* TemplateApplication; 	/* defined in main.cpp */

#define COMBOBOX_ID 99 
#define PMBUTTON1 100
#define PMBUTTON2 101
#define PMBUTTON3 102

#define LPC_STATUS 	1
#define LPC_PRINTCAP 	2
#define LPC_HOLDALL 	3
#define LPC_NOHOLDALL   4
#define LPC_RELEASE     5
#define LPC_HOLD	6


#include "../config.h"
//#define LPC_BIN "/usr/local/bin/lpc"
//#define LPQ_BIN "/usr/local/bin/lpq"
//#define LPRM_BIN "/usr/local/bin/lprm"


mainDlg::mainDlg(QWidget *, const char *name)
	: KTopLevelWidget( name )
{
    resize ( 640 , 400 );
    myView = new mainView(this); // needed from toolbar
    myView->selectedPrinter = "all";
    setView(myView);
    SetupMainMenuBar();
    SetupToolBar();
    SetupStatusBar();
}


/****************************************************************************
 * 
 * SetupToolBar - Do the necessary initialization for the Toolbar
 *
 ****************************************************************************/
void 
mainDlg::SetupToolBar()
{
  KIconLoader *loader;

  toolbar 	= new KToolBar( this );
  loader	= TemplateApplication->getIconLoader();
  toolbar->setBarPos( KToolBar::Left );
  toolbar1	= addToolBar(toolbar);

  toolbar->insertCombo(	"all     ", 
  			COMBOBOX_ID , 0, 
			SIGNAL(activated(const char*)), this,
			SLOT(ListPrintQueue()));
  toolbar->insertButton(loader->loadIcon("exit.xpm"), 
  			PMBUTTON1,
		      	SIGNAL(clicked()), 
			myView,
		      	SLOT(RemoveJob()), 
			TRUE, 
			i18n("Druckauftrag lschen"));
  toolbar->insertButton(loader->loadIcon("play.xpm"), 
  			PMBUTTON2,
		      	SIGNAL(clicked()), 
			myView,
		      	SLOT(ReleaseAll()), 
			TRUE, 
			i18n("Drucken starten"));
  toolbar->insertButton(loader->loadIcon("pause.xpm"), 
			PMBUTTON3,
		      	SIGNAL(clicked()), 
			myView,
		      	SLOT(HoldAll()), 
			TRUE, 
			i18n("Drucken anhalten"));

  updateToolBarComboBox();
  enableToolBar( KToolBar::Show, toolbar1 );
}


void
mainDlg::updateToolBarComboBox()
{
  // We fetch the PrinterList from the mainView
  int i;
  myView->PrinterList.first ();
  QString *item = myView->PrinterList.getFirst ();

  for (i = 0; i < myView->PrinterList.count (); i++)
    {
      toolbar->insertComboItem (COMBOBOX_ID, item->data (), -1);
      item = myView->PrinterList.next ();
    }

}
void 
mainDlg::ListPrintQueue ()
{
  const char *printer;
  printer = toolbar->getComboItem (COMBOBOX_ID, -1);	//get current combo item

  myView->selectedPrinter = QString (printer);
  myView->ListPrintQueue ();
}
void
mainDlg::SetupMainMenuBar()
{
  menubar = new KMenuBar (this, "menubar");
  file = new QPopupMenu ();
  edit = new QPopupMenu ();
  options = new QPopupMenu ();
  help = new QPopupMenu ();

  file->insertItem (i18n ("&Installieren"),
		    this, SLOT (PrinterMenuNew ()));
  file->insertSeparator (-1);
  file->insertItem (i18n ("Drucker &anhalten"),
		    myView, SLOT (HoldAll ()));
  file->insertItem (i18n ("Als Standardrucker &verwenden"),
		    this, SLOT (PrinterMenuClose ()));
  file->insertItem (i18n ("Einstellung fr Dokumente..."),
		    this, SLOT (PrinterMenuSave ()));
  file->insertItem (i18n ("F&reigabe..."),
		    this, SLOT (PrinterMenuSaveAs ()));
  file->insertSeparator (-1);
  file->insertItem (i18n ("Druckauftrge &lschen"),
		    this, SLOT (PrinterMenuExit ()));
  file->insertSeparator (-1);
  file->insertItem (i18n ("&Eigenschaften"),
		    this, SLOT (PrinterMenuExit ()));
  file->insertSeparator (-1);
  file->insertItem (i18n ("&Schlieen"),
		    this, SLOT (PrinterMenuExit ()));

  /* 
   * Insert Items for Edit Menu 
   */

  edit->insertItem (i18n ("An&halten"),
		    this, SLOT (EditMenuUndo ()));
  edit->insertItem (i18n ("&Fortsetzen"),
		    this, SLOT (EditMenuUndo ()));
  edit->insertItem (i18n ("&Neu starten"),
		    this, SLOT (EditMenuUndo ()));
  edit->insertSeparator (-1);
  edit->insertItem (i18n ("&Abbrechen"),
		    this, SLOT (EditMenuCut ()));
  edit->insertSeparator (-1);
  edit->insertItem (i18n ("&Eigenschaften"),
		    this, SLOT (EditMenuCopy ()));

  options->insertItem (i18n ("&Statusleiste"),
		       this, SLOT (OptionsMenuConfigure ()));
  options->insertItem (i18n ("A&ktualisieren"),
		       this, SLOT (ListPrintQueue ()));

  /* Help Menu is special */
  help = TemplateApplication->getHelpMenu (FALSE, i18n("klpc 0.3\n\n"
			    "(c) Dietmar Kling (dietmar.kling@usa.net) \n"));

  /* 
   * Equip menubar
   */

  menubar->setGeometry (0, 0, 400, 30);
  menubar->insertItem (i18n ("&Drucker"), file);
  menubar->insertItem (i18n ("Do&kument"), edit);
  menubar->insertItem (i18n ("&Ansicht"), options);
  menubar->insertSeparator (-1);
  menubar->insertItem (i18n ("&Hilfe"), help);

  setMenu (menubar);
  menubar->show ();
}

void
mainDlg::PrinterMenuNew()
{
	/* Tell us something about you */
    QDialog *dlg = new gsSetupDlg(this);
    /*
    QPoint point = this->mapToGlobal (QPoint (0,0));
    QRect pos 	 = this->geometry();
    dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
		     point.y() + pos.height()/2 - dlg->height()/2, 
		     dlg->width(),dlg->height());
     */

    dlg->exec();
    delete dlg;
}

void
mainDlg::PrinterMenuOpen()
{
	/* Tell us something about you */
	printf("PrinterMenuOpen()\n");
}
void
mainDlg::PrinterMenuClose()
{
	/* Tell us something about you */
	printf("PrinterMenuClose()\n");
}
void
mainDlg::PrinterMenuSave()
{
	/* Tell us something about you */
	printf("PrinterMenuSave()\n");
}
void
mainDlg::PrinterMenuSaveAs()
{
	/* Tell us something about you */
	printf("PrinterMenuSaveAs()\n");
}
void
mainDlg::PrinterMenuExit()
{
	/* Tell us something about you */
	printf("PrinterMenuExit()\n");
	
	TemplateApplication->quit();
}

void 
mainDlg::EditMenuUndo()
{
	printf("EditMenuUndo()\n");
}
void 
mainDlg::EditMenuCut()
{
	printf("EditMenuCut()\n");
}
void 
mainDlg::EditMenuCopy()
{
	printf("EditMenuCopy\n");
}
void 
mainDlg::EditMenuPaste()
{
  printf("EditMenuPaste()\n");
}

void 
mainDlg::OptionsMenuConfigure()
{
  printf("OptionsMenuConfigure()\n");
}

void
mainDlg::SetupStatusBar()
{
  statusbar = new KStatusBar( this );
  statusbar->insertItem(i18n("Druckerstatus: angehalten"), ID_LINE_COLUMN);
  statusbar->insertItem(i18n("   "), ID_INS_OVR);
  statusbar->insertItem(i18n("0 Auftrge in Warteschlange"), ID_GENERAL);

  statusbar->setInsertOrder(KStatusBar::RightToLeft);
  statusbar->setAlignment(ID_INS_OVR,AlignCenter);
    
  setStatusBar( statusbar );

}


mainDlg::~mainDlg()
{
  delete statusbar;
  delete toolbar;
  delete menubar;
}
