#ifndef __MAINVIEW__
#define __MAINVIEW__

#include <ktopwidget.h>
#include <kstatusbar.h>
#include <kprocess.h>
#include <qlist.h>
#include <qlistbox.h>
#include <qmlined.h>
#include <ktablistbox.h>
#include <qtimer.h>
class mainView : public QWidget
{
    Q_OBJECT;

public:
    mainView
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );
    
    KTabListBox * SetupListBox();
    void DestroyListBox();
    virtual ~mainView();

    QMultiLineEdit *MultiLineEdit;

    QList <QString> PrinterList;  // All Printer we have
    QString selectedPrinter;

    QTimer *buggy;

    int lpqrunning;
private:    
	/* Bools*/
	int holdall;
	int LpcCommand;
	
	char *lpqbuf;
	char *lpqbufrun; // run Variable
	QString LpqBuffer;
	QString LpcBuffer;
	
	/* Object for keys */

	QAccel *accel;
	
	/* QListBox */

	//QListBox *ListBox;
	KTabListBox *ListBox;
	
	/* QComboBox */

	QComboBox *ComboBox;
	
	/* KProcess */

	KProcess *lpq;
	KProcess *lpc;
	KProcess *lprm;
	
public slots:

	void resizeEvent( QResizeEvent *);

	/* Processes */
	void LpqReadStdout(KProcess *, char *, int);
	void LpqProcessExited(KProcess *);
	
	void LpcExecute();
	void LpcReadStdout(KProcess *, char *, int);
	void LpcProcessExited(KProcess *);

	void ListPrintQueue();
	void RemoveJob();
	
	void HoldAll();
	void ReleaseAll();
	void HoldAllStatus();

protected slots:
};
#endif
