/*
    look@seti
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    
#ifndef _CHART_H_
#define _CHART_H_

#include <stdio.h>
#include <qwindow.h>
#include <qpainter.h> 
#include <qpixmap.h>
#include <qdatetime.h>
#include <qfile.h>
#include <qimage.h>
#include <qdir.h>
#include <qlistview.h>
#include <qmessagebox.h>
#include <ktabctl.h>
#include <kiconloader.h>
#include <ktopwidget.h>
#include <ktmainwindow.h>
#include "globals.h"

class TChart : public QWindow
{
   Q_OBJECT
public:
   QString StartupFile;
   QListView *SetiList;
   TChart(QWidget* parent=0, const char* name=0, WFlags f=0);
   ~TChart();
   int GetUpdateIntervall();
   int SetUpdateIntervall(int Interv);
protected:
   void paintEvent( QPaintEvent * );
   void resizeEvent( QResizeEvent * );  
   void mousePressEvent( QMouseEvent * );  

public slots:
   void AddWatch();
   void EditWatch();
   void RemoveWatch();
   void RemoveAllWatches();
   void LoadWatches();
   void SaveWatches();
   void TimerTic();
   void ShowDetails();
   void ShowSkymap();
   void ShowPanelIcon();
   void SetupOptions();
   void PanelViewOptions();
   void SaveOptions();
   void TabSelectClick(int);
   void MouseClick( QListViewItem *, const QPoint &, int);
   
   void ShowPnlPopup(QMouseEvent*);

private:
   QPainter* Paint;
   QTimer* Timer;
   QLabel* ProgressLab;
   QListView *UserList, *UnitList1, *UnitList2, *TimesList, *UnitTimesList, *LocationList,
             *VersionList;
   KTabCtl* TabBar;
   struct SetiRec* SetiArr[MAXSETI];
   int SetiCount;       // Anzahl der aktiven berwachungen
   int Intervall;       // Abfrageintervall (ms)
   unsigned long LoeschBlock;// Gre des zu lschenden Speicherbereiches in memset
   KConfig* Config;
   int StateStatus;     // Status der Datei "state.sah"
   int WTempStatus;     // Status der Datei "wtemp.sah"
   int WorkUnitStatus;  // Status der Datei "state.sah"
   int CurrentTab;      // aktiver Tab im Tabcontrol (0..5)
   QPopupMenu *Popup;   // Popup-men fr Taskbar
   QPopupMenu *ListPopup; // Men for Listenanzeige

   int AddSeti(QString Name, QString Dir);   
   int ScanSeti(QListViewItem* QL, QDir D);
   int ScanState(QString Datei, SetiPtr SP); // State.sah scannen
   int ScanVersion(QString Datei, SetiPtr SP); // version.sah scannen
   int ScanWTemp(QString Datei, SetiPtr SP); // wtemp.sah scannen
   int ScanUserInfo(QString Datei, SetiPtr SP); // user_info.sah scannen
   int ScanWorkUnit(QString Datei, SetiPtr SP, int LinesToScan); // work_unit.sah scannen
   void CalcStatus(SetiPtr SP);       // Status ermitteln
   int SetStatus(QListViewItem* QL,int Status);  // Statusicon aktualisieren
   void AddWatches(QString DateiName);
   void UpdateGrid(QListViewItem* QL, SetiPtr SP);  // Grid aktualisieren
   void UpdateUserGrid();     // Userdaten-Grid aktualisieren
   void UpdateTimesGrid();    // Zeitendaten-Grid aktualisieren
   void UpdateUnitsGrid();    // Unitdaten-Grid aktualisieren
   void UpdateUnitTimesGrid();// Unit-Zeitendaten-Grid aktualisieren
   void UpdateLocationGrid(); // Location-Grid aktualisieren
   void UpdateVersionGrid();  // Versionen anzeigen
   void ReadConfig();
   void SaveConfig();
   QListViewItem* GetCurrentWatch(void); // markierten Eintrag in der Liste bestimmen
   SetiPtr GetCurrentSeti(void); // mark. Eintr. best. und Zeiger auf Datenstruktur
};

#endif