#include <stdio.h>
#include <kapp.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <qstrlist.h>
#include <qbuttongroup.h>
#include "dlgpnlopt.h"

extern int FirstLineType,SecondLineType;  // Was wird in den Zeilen angezeigt

PanelOptDlg::PanelOptDlg(QWidget* parent=0, const char* name=0):
     QDialog (parent, name, TRUE)
{
//KIconLoader IconLoader;
char *FTxt[FIRSTMAX] = {"Name","User","Percent","Elapsed Time","Remaining Time"};
char *STxt[SECONDMAX] = {"User","Percent","Elapsed Time","Remaining Time","Peak Score","Gaussian Score"};
int i;

   setFixedSize(400,250);
   setCaption(i18n("look@seti Panel Options"));

   QButtonGroup * FGrp=new QButtonGroup(i18n("First Line"), this);
   FGrp->setGeometry(10,10,180,160);
   for (i=0;i<FIRSTMAX;i++) {
      FirstRb[i] = new QRadioButton(i18n(FTxt[i]),FGrp);
      FirstRb[i]->setGeometry(10,20+20*i,160,20);
   }
   
   QButtonGroup * SGrp=new QButtonGroup(i18n("Second Line"), this);
   SGrp->setGeometry(210,10,180,160);
   for (i=0;i<SECONDMAX;i++) {
      SecondRb[i] = new QRadioButton(i18n(STxt[i]),SGrp);
      SecondRb[i]->setGeometry(10,20+20*i,160,20);
   }

   // Radiobuttons initialisieren
   if ( (FirstLineType>=0) && (FirstLineType<FIRSTMAX) )
      FirstRb[FirstLineType]->setChecked(TRUE);
   if ( (SecondLineType>=0) && (SecondLineType<SECONDMAX) )
      SecondRb[SecondLineType]->setChecked(TRUE);
   
   QPushButton *OkBtn = new QPushButton(i18n("OK"), this, "OkBtn");
   OkBtn->setGeometry(30,height()-40,80,30);
   connect(OkBtn, SIGNAL(clicked()), SLOT(accept()) );

   QPushButton *CancelBtn = new QPushButton(i18n("Cancel"), this, "CancelBtn");
   CancelBtn->setGeometry(width()-110,height()-40,80,30);
   connect(CancelBtn, SIGNAL(clicked()), SLOT(reject()) );
}

void PanelOptDlg::SetData(void) {
// Daten aus dem dialog auf die entspr. Variablen setzen (nach 'ok'-Click)
int i;

   for (i=0;i<FIRSTMAX;i++) {
      if (FirstRb[i]->isChecked()) {
         FirstLineType=i;
         break;
      }
   }
   for (i=0;i<SECONDMAX;i++) {
      if (SecondRb[i]->isChecked()) {
         SecondLineType=i;
         break;
      }
   }
}