/*
    look@seti -
    Copyright (C) 1999 Jrgen Hochwald <hochwald@kde.org>
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
			
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
					
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/    

#include "pnldock.h"
#include "chart.h"
#include <qsignal.h>
#include <kwm.h>
#undef Status

int FirstLineType,SecondLineType;  // Was wird in den Zeilen angezeigt
DoubleDock *pdk;                   // Panelanzeige
extern TChart *Chart;


PnlDock::PnlDock(QWidget *parent, const char *name) : QWidget(parent,name)
{
   KWM::setDockWindow(winId());
//   setBackgroundColor(QColor(0, 0, 0));
   resize(PSIZE, PSIZE);

   show();
}


PnlDock::~PnlDock()
{

}

void PnlDock::mousePressEvent(QMouseEvent *Event)
{
//debug("mouseclick");
   emit mouseClick(Event);
}

void PnlDock::paintEvent(QPaintEvent *Event)
{
//debug("paint");
//   QPainter p(this);
}

// -------------------------

DoubleDock::DoubleDock() {
   SP=NULL;
   Pix = new QPixmap(PSIZE+PSIZE,PSIZE);
   D1 = new PnlDock();
   D2 = new PnlDock();
   debug("connect...");
   connect(D1, SIGNAL(mouseClick(QMouseEvent*)), Chart, SLOT(ShowPnlPopup(QMouseEvent*)));
   connect(D2, SIGNAL(mouseClick(QMouseEvent*)), Chart, SLOT(ShowPnlPopup(QMouseEvent*)));
   Update();
}

DoubleDock::~DoubleDock() {
   delete D2;
   delete D1;
   delete Pix;
}

void DoubleDock::Update(void) {
QPixmap P1,P2;
QPainter p;
int i;
char Progress[20], Text[40];

   P1.resize(PSIZE,PSIZE);
   P2.resize(PSIZE,PSIZE);
   p.begin(Pix);
   p.fillRect(0,0,PSIZE+PSIZE,PSIZE, QColor(qRgb(0,0,0)));
   if (SP) {
      switch (SP->Status) {
         case S_READY     : i=PSIZE+PSIZE;
                            sprintf(Progress,"finish");
                            break;
         case S_RECEIVING : i = (int)(SP->Progress/350.0*(PSIZE+PSIZE));
                            if (i>PSIZE+PSIZE) i=PSIZE+PSIZE;
                            sprintf(Progress,"%0.0fkb",SP->Progress);
                            break;
         default          : if (SP->Progress<0) {
                               i=0;
                               sprintf(Progress,"0.0%%");
                            } else {
                               i = (int)(SP->Progress*2*PSIZE);
                               sprintf(Progress,"%0.1f%%",100.0*SP->Progress);
                            }
      }
      p.fillRect(0,0,i,PSIZE, QColor(qRgb(64,64,64)));
      p.setPen(qRgb(160,160,160));
      Text[0]='\0';
      switch (FirstLineType) {
         case P1_NAME      : strcpy(Text,SP->Name); break;
         case P1_USER      : strcpy(Text,SP->UserName); break;
         case P1_PERCENT   : strcpy(Text,Progress);  break;
         case P1_ELAPSED   : strcpy(Text,SP->Elapsed); break;
         case P1_REMAINING : strcpy(Text,SP->Remain); break;
      }
      p.drawText(0,-1, PSIZE+PSIZE,PSIZE/2, AlignHCenter, Text);
      Text[0]='\0';
      switch (SecondLineType) {
         case P2_USER      : strcpy(Text,SP->UserName); break;
         case P2_PERCENT   : strcpy(Text,Progress);  break;
         case P2_ELAPSED   : strcpy(Text,SP->Elapsed); break;
         case P2_REMAINING : strcpy(Text,SP->Remain); break;
         case P2_PEAK      : sprintf(Text,"%0.4f",SP->Bs_Score); break;
         case P2_GAUSSIAN  : sprintf(Text,"%0.4f",SP->Bg_Score); break;
      }
      p.drawText(0,PSIZE/2-1, PSIZE+PSIZE,PSIZE/2, AlignHCenter, Text);
   }
   bitBlt(&P1,0,0,  Pix,0,0,PSIZE,PSIZE, CopyROP, TRUE);
   bitBlt(&P2,0,0,  Pix,PSIZE,0,PSIZE,PSIZE, CopyROP, TRUE);
   //D1->NameLab->setPixmap(P1);
   //D2->NameLab->setPixmap(P2);
   D1->setBackgroundPixmap(P1);
   D2->setBackgroundPixmap(P2);

   p.end();
}

void DoubleDock::SetSeti(SetiPtr S) {
   SP=S;
}

