//==========================================================================
//
//   MainFrame.cpp
//
//==========================================================================

#include <iostream.h>

#include <qpopmenu.h>
#include <qkeycode.h>

#include <kapp.h>
#include <kfiledialog.h>
#include <kslider.h>
#include <kwm.h>

#include "mainframe.h"

//--------------------------------------------------------------------------
//   Construction
//--------------------------------------------------------------------------

MainFrame::MainFrame() :
    KTopLevelWidget("KTest"),
    menuBar(this), toolBar(this), statusBar(this), view(this)
{
    initMenuBar();
    initToolBar();
    initStatusBar();
    initView();
}

void MainFrame::initMenuBar()
{
    //================================================== File Menu
    
    QPopupMenu *fileMenu = new QPopupMenu();
    CHECK_PTR(fileMenu);
    
    fileMenu->insertItem(i18n("&Save"), this, SLOT(slotSave()), CTRL+Key_S);
    fileMenu->insertSeparator();
    fileMenu->insertItem(i18n("E&xit"), kapp,
		      SLOT(quit()), CTRL+Key_Q);

    //================================================== View Menu

    QPopupMenu *viewMenu = new QPopupMenu();
    CHECK_PTR(viewMenu);

    viewMenu->insertItem(i18n("Zoom &in"), &view, SLOT(slotIncZoom()));
    viewMenu->insertItem(i18n("Zoom &out"), &view, SLOT(slotDecZoom()));
    viewMenu->insertSeparator();
    viewMenu->insertItem(i18n("&Replace"), &view, SLOT(slotReplace()));

    //================================================== Help Menu
    
    QPopupMenu *helpMenu;
    helpMenu = kapp->getHelpMenu
	(true, i18n("KMag was created by\n"
		    "Michael Forster (forster@fmi.uni-passau.de).\n\n"
		    "It is distributed under the GPL."));
    
    //================================================== Menu Bar
    
    menuBar.insertItem(i18n("&File"), fileMenu );
    menuBar.insertItem(i18n("&View"), viewMenu );
    menuBar.insertItem(i18n("&Help"), helpMenu );
    setMenu(&menuBar);

}

void MainFrame::initToolBar()
{
    QString path(kapp->kde_toolbardir() + "/");
    QPixmap pixmap;

    pixmap.load(path + "exit.xpm");
    toolBar.insertButton(pixmap, 0,
			 SIGNAL(clicked()), kapp, SLOT(quit()),
			 true, i18n("Exit"));
    
    toolBar.insertSeparator();
    
    pixmap.load(path + "filefloppy.xpm");
    toolBar.insertButton(pixmap, 0,
			 SIGNAL(clicked()), this, SLOT(slotSave()),
			 true, i18n("Save File"));
    
    toolBar.insertSeparator();

    //================================================== Zoom Slider

    KSlider *slider = new KSlider(1, 16, 1, 1, KSlider::Horizontal, &toolBar);
    QLabel *label = new QLabel(slider, i18n("Zoom:"), &toolBar);
    QLabel *number = new QLabel(slider, "16", &toolBar);

    label->setAutoResize(true);
    number->setAutoResize(true);
     
    toolBar.insertWidget(0, label->width(), label);
    toolBar.insertWidget(1, number->width(), number);
    toolBar.insertWidget(2, slider->width(), slider);

    connect(slider, SIGNAL(valueChanged(int)),
	    number, SLOT(setNum(int)));
    connect(slider, SIGNAL(valueChanged(int)),
	    &view,  SLOT(slotSetZoom(int)));
    connect(&view,  SIGNAL(zoomChanged(int)),
	    slider, SLOT(setValue(int)));
    
    //================================================== Insert Toolbar
    
    addToolBar(&toolBar);
}

void MainFrame::initStatusBar()
{
    statusBar.insertItem("Test", 0);
    
    setStatusBar(&statusBar);
}

void MainFrame::initView()
{
    setView(&view);
    view.slotSetZoom(2);
}

//--------------------------------------------------------------------------
//   Slots
//--------------------------------------------------------------------------

void MainFrame::slotSave()
{
    KDEBUG(KDEBUG_INFO, 0, "MainFrame::slotSave() -- not yet implemented");
}

//--------------------------------------------------------------------------
//   end of file
//--------------------------------------------------------------------------


