#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>

#include <sys/ioctl.h>

#include "memmap.h"

int main( int argc, char **argv )
{
	int fd, result, pages, page ;
	char type ;

	if (argc<3 )
	{
		printf ( "Usage: ioctl <file> <cmd> [ arg ] \n") ;
		printf ( "<cmd> = reset | pages | page [num]\n") ;
		exit(1) ;
	}

	printf("ioctl - small utility to debug memmap.o\n" ) ;

	fd = open( argv[1], O_RDONLY ) ;

	if ( fd>=0 )
	{
		printf("Opened %s using fd: \"%d\"\n", argv[1], fd ) ;

		if ( strcmp( argv[2], "reset" )==0 )
		{
			printf("Resetting memmap...\n" ) ;
			result = ioctl( fd, MEMMAP_IOCTL_RESET ) ;
			printf( "result=%d\n", result ) ; 
		} else if ( strcmp( argv[2], "pages")==0 ) 
		{
			printf("Getting number of pages (now %d)\n", pages ) ;
			result = ioctl( fd,
					MEMMAP_IOCTL_GET_NR_OF_PAGES, &pages ) ;
			printf("result=%d, pages=%d\n", result,pages ) ;
                } else if ( strcmp( argv[2], "page")==0 )
                {
			page = atoi( argv[3] ) ;
                        printf("Getting memtype for page %d\n", page ) ;
                        result = ioctl( fd, MEMMAP_IOCTL_GET_PAGE, &type ) ;
                        printf("result=%d, mem_type=%d\n", result, type ) ;
		} else
		{
			printf("%s is invalid command\n", argv[2] ) ;
		}
		close( fd ) ;
	}
	else
	{
		printf("opening %s failed (return value %d, errno %d)\n",
			argv[1], fd, errno ) ;
	}

	return 0 ;
}
