#ifndef KMEMSTAT_H 
#define KMEMSTAT_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qpopupmenu.h>
#include <qevent.h>

#include <kapp.h>
#include <ktmainwindow.h>
#include <kconfig.h>
#include <kaccel.h>

#include "kmemstatwidget.h"

/**
 * This is the main windows for KMemStat.
 *
 */
class KMemStat : public KTMainWindow
{
	Q_OBJECT
public:
	KMemStat( char *name=0 );
	virtual ~KMemStat();

public slots:
	void slotDropEvent(KDNDDropZone *);
	void slotToolbarClicked(int);

	void configProgram() ;
	void configKeys() ;

protected slots:
	void readProperties( KConfig * );
	void saveProperties( KConfig * );

	void mousePressEvent( QMouseEvent* );
	void timerEvent( QTimerEvent * ) ;
 
private:
	void createMenu() ;
	void createToolBar() ;
	void createStatusBar() ;
	void createAccel() ;

private slots:
	void updateStatusBar() ;
 
	void showHelp() ;
	void quitApplication() ;
	void notImpl() ;

private:
	KMemStatWidget *view;
	KAccel *accel ;
	QPopupMenu *file_menu, *options_menu, *help_menu, *mouse_menu ;
	enum {TOOLBAR_EXIT, TOOLBAR_HELP};

	KStatusBar *statusbar ;
	enum {STATUSBAR_MEM_FREE, STATUSBAR_MEM_SWAP, STATUSBAR_REST } ;
	static const int STATUSBAR_UPDATE_TIME = 500 ;
};

#endif // KMEMSTAT_H 
